/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.antlr.GroovyTokenTypeBridge;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.KlenkDocumentScanner;
import org.codehaus.groovy.eclipse.refactoring.formatter.LineIndentations;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GroovyIndentation {
    private static boolean DEBUG = false;
    private final DefaultGroovyFormatter formatter;
    private final IFormatterPreferences pref;
    private int indentation = 0;
    private final int[] tempIndentation;
    private final LineIndentations lineInd;
    TextEdit indentationEdits;
    private final KlenkDocumentScanner tokens;

    private void debug(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    public GroovyIndentation(DefaultGroovyFormatter formatter, IFormatterPreferences pref, int indentationLevel) {
        this.formatter = formatter;
        this.tempIndentation = new int[formatter.getProgressDocument().getNumberOfLines()];
        this.lineInd = new LineIndentations(formatter.getProgressDocument().getNumberOfLines());
        this.tokens = formatter.getTokens();
        this.pref = pref;
        this.indentation = indentationLevel;
    }

    public TextEdit getIndentationEdits() {
        this.indentationEdits = new MultiTextEdit();
        this.handleMultilineMethodParameters();
        try {
            if (this.formatter.isMultilineStatement(this.tokens.get(0))) {
                this.setAdditionalIndentation(this.tokens.get(0), this.pref.getIndentationMultiline(), false);
                this.lineInd.setMultilineToken(this.tokens.get(0).getLine(), this.tokens.get(0));
            }
            Token token = null;
            int i = 0;
            while (i < this.tokens.size()) {
                token = this.tokens.get(i);
                int offsetToken = this.formatter.getOffsetOfToken(token);
                int offsetNextToken = this.formatter.getOffsetOfToken(this.formatter.getNextTokenIncludingNLS(i));
                int ttype = token.getType();
                if (ttype == GroovyTokenTypeBridge.LITERAL_if || ttype == GroovyTokenTypeBridge.LITERAL_while || ttype == GroovyTokenTypeBridge.LITERAL_for) {
                    this.setAdditionalIndentation(this.formatter.getTokenAfterParenthesis(i));
                } else if (ttype == GroovyTokenTypeBridge.LCURLY || ttype == GroovyTokenTypeBridge.LBRACK) {
                    ++this.indentation;
                } else if (ttype == GroovyTokenTypeBridge.LITERAL_switch) {
                    this.indentendSwitchStatement(token);
                } else if (ttype == GroovyTokenTypeBridge.RCURLY || ttype == GroovyTokenTypeBridge.RBRACK) {
                    --this.indentation;
                } else if (ttype == GroovyTokenTypeBridge.LITERAL_else) {
                    int nextToken = this.formatter.getNextToken(i).getType();
                    if (nextToken != GroovyTokenTypeBridge.LCURLY && nextToken != GroovyTokenTypeBridge.LITERAL_if) {
                        this.setAdditionalIndentation(this.formatter.getNextToken(i));
                    }
                } else if (ttype == GroovyTokenTypeBridge.EOF || ttype == GroovyTokenTypeBridge.NLS) {
                    int nextTokenType = this.formatter.getNextTokenIncludingNLS(i).getType();
                    if (nextTokenType == GroovyTokenTypeBridge.RCURLY || nextTokenType == GroovyTokenTypeBridge.RBRACK) {
                        int n = token.getLine();
                        this.tempIndentation[n] = this.tempIndentation[n] - 1;
                    }
                    this.deleteWhiteSpaceBefore(token);
                    if (ttype != GroovyTokenTypeBridge.EOF) {
                        Token nextMultiToken = this.formatter.getNextTokenIncludingNLS(i);
                        int offsetAfterNLS = offsetToken + this.formatter.getProgressDocument().getLineDelimiter(token.getLine() - 1).length();
                        if (!this.isEmptyLine(token.getLine()) || this.formatter.pref.isIndentEmptyLines()) {
                            this.addEdit((TextEdit)new ReplaceEdit(offsetAfterNLS, offsetNextToken - offsetAfterNLS, this.formatter.getLeadingGap(this.indentation + this.tempIndentation[token.getLine()])));
                        }
                        this.lineInd.setLineIndentation(token.getLine() + 1, this.indentation + this.tempIndentation[token.getLine()]);
                        if (this.formatter.isMultilineStatement(nextMultiToken)) {
                            this.setAdditionalIndentation(nextMultiToken, this.pref.getIndentationMultiline(), false);
                            this.lineInd.setMultilineToken(token.getLine(), token);
                        }
                    }
                } else if (ttype == GroovyTokenTypeBridge.ML_COMMENT) {
                    this.addEdit((TextEdit)new ReplaceEdit(offsetToken, offsetNextToken - offsetToken, this.formatMultilineComment(this.formatter.getProgressDocument().get(offsetToken, offsetNextToken - offsetToken), this.indentation)));
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            GroovyCore.logException("Exception thrown while determining indentation", e);
        }
        return this.indentationEdits;
    }

    private void handleMultilineMethodParameters() {
        ModuleNode rootNode = this.formatter.getProgressRootNode();
        List<ClassNode> classes = rootNode.getClasses();
        int indentationMultiline = this.pref.getIndentationMultiline();
        for (ClassNode classNode : classes) {
            List<MethodNode> methods = classNode.getMethods();
            for (MethodNode method : methods) {
                int lineEnd;
                if (method.getEnd() <= 1 || method.getParameters() == null || method.getParameters().length <= 0) continue;
                Parameter[] ps = method.getParameters();
                Statement code = method.getCode();
                Parameter lastP = ps[ps.length - 1];
                int maybeMethodStart = method.getAnnotations() != null && !method.getAnnotations().isEmpty() ? method.getAnnotations().get(method.getAnnotations().size() - 1).getEnd() : method.getStart();
                List<Token> methodTokens = this.tokens.getTokens(maybeMethodStart, method.getParameters()[0].getStart());
                int lineStart = method.getLineNumber();
                int i = methodTokens.size() - 1;
                while (i >= 0) {
                    Token token = methodTokens.get(i);
                    if (token.getType() == GroovyTokenTypeBridge.LPAREN) {
                        lineStart = token.getLine();
                        break;
                    }
                    --i;
                }
                int n = lineEnd = code != null ? code.getLineNumber() : lastP.getLastLineNumber();
                if (lineStart == lineEnd) continue;
                int tokenIndex = this.tokens.findTokenFrom(lastP.getEnd());
                Token lastParamToken = this.tokens.get(tokenIndex - 1);
                Token openingBracket = null;
                while (++tokenIndex < this.tokens.size()) {
                    openingBracket = this.tokens.get(tokenIndex);
                    if (openingBracket.getType() == GroovyTokenTypeBridge.LCURLY) break;
                }
                boolean doLastLineIndent = openingBracket != null && lastParamToken.getLine() == openingBracket.getLine();
                int i2 = lineStart + 1;
                while (i2 < lineEnd) {
                    int n2 = i2 - 1;
                    this.tempIndentation[n2] = this.tempIndentation[n2] + indentationMultiline;
                    ++i2;
                }
                if (!doLastLineIndent) continue;
                int n3 = lineEnd - 1;
                this.tempIndentation[n3] = this.tempIndentation[n3] + indentationMultiline;
            }
        }
    }

    private boolean isEmptyLine(int line) {
        try {
            IDocument d = this.formatter.getProgressDocument();
            int lineStart = d.getLineOffset(line);
            int lineLen = d.getLineLength(line);
            String lineTxt = d.get(lineStart, lineLen);
            boolean result = lineTxt.trim().equals("");
            return result;
        }
        catch (BadLocationException e) {
            return true;
        }
    }

    private void deleteWhiteSpaceBefore(Token token) throws BadLocationException {
        int endPos;
        int startPos = endPos = this.tokens.getOffset(token);
        IDocument d = this.formatter.getProgressDocument();
        while (startPos > 0 && this.isTabOrSpace(d.getChar(startPos - 1))) {
            --startPos;
        }
        if (!this.formatter.pref.isIndentEmptyLines() || !this.isEmptyLine(this.formatter.getProgressDocument().getLineOfOffset(startPos))) {
            this.addEdit((TextEdit)new DeleteEdit(startPos, endPos - startPos));
        }
    }

    private boolean isTabOrSpace(char c) {
        return c == ' ' || c == '\t';
    }

    private void indentendSwitchStatement(Token token) {
        ASTNode node;
        if (token != null && (node = this.formatter.findCorrespondingNode(token)) instanceof SwitchStatement) {
            SwitchStatement switchstmt = (SwitchStatement)node;
            for (CaseStatement cs : switchstmt.getCaseStatements()) {
                this.indentendBlockStatement(cs.getCode(), cs.getLineNumber());
            }
            Statement defaultstmt = switchstmt.getDefaultStatement();
            int posDef = this.formatter.getPosOfToken(defaultstmt.getLineNumber(), defaultstmt.getColumnNumber());
            if (posDef != -1) {
                Token def = this.formatter.getPreviousToken(posDef);
                this.indentendBlockStatement(switchstmt.getDefaultStatement(), def.getLine());
            }
        }
    }

    private void indentendBlockStatement(Statement stmt, int currentLine) {
        if (stmt instanceof BlockStatement) {
            BlockStatement defaultBlock = (BlockStatement)stmt;
            for (Statement sm : defaultBlock.getStatements()) {
                if (sm.getLineNumber() <= currentLine) continue;
                int i = sm.getLineNumber();
                while (i <= sm.getLastLineNumber()) {
                    int n = i - 1;
                    this.tempIndentation[n] = this.tempIndentation[n] + 1;
                    ++i;
                }
            }
        }
    }

    private void addEdit(TextEdit edit) {
        if (edit instanceof DeleteEdit && edit.getLength() == 0) {
            return;
        }
        if (edit instanceof ReplaceEdit && edit.getLength() == 0 && ((ReplaceEdit)edit).getText().length() < 1) {
            return;
        }
        if (edit instanceof InsertEdit && ((InsertEdit)edit).getText().length() < 1) {
            return;
        }
        if (edit != null && edit.getOffset() >= this.formatter.formatOffset && edit.getOffset() + edit.getLength() <= this.formatter.formatOffset + this.formatter.formatLength) {
            if (edit instanceof DeleteEdit) {
                this.debug("DeleteEdit: " + edit.getOffset() + ":" + edit.getLength());
                this.debug("---------------------------");
                IDocument doc = this.formatter.getProgressDocument();
                try {
                    this.debug(String.valueOf(doc.get(0, edit.getOffset())) + "|*>" + doc.get(edit.getOffset(), edit.getLength()) + "<*|" + doc.get(edit.getOffset() + edit.getLength(), doc.getLength() - (edit.getOffset() + edit.getLength())));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                this.debug("---------------------------");
            }
            try {
                this.indentationEdits.addChild(edit);
            }
            catch (MalformedTreeException e) {
                this.debug("Ignored conflicting edit: " + edit);
                GroovyCore.logException("WARNING: Formatting ignored a conflicting text edit", e);
            }
        }
    }

    private void setAdditionalIndentation(Token token, int indent, boolean firstLineInlcuded) throws BadLocationException {
        if (token != null) {
            ASTNode node;
            while (token.getType() == GroovyTokenTypeBridge.SL_COMMENT) {
                int n = token.getLine() - 1;
                this.tempIndentation[n] = this.tempIndentation[n] + indent;
                token = this.formatter.getNextToken(this.formatter.getPosOfToken(token));
            }
            if (token.getType() != GroovyTokenTypeBridge.LCURLY && (node = this.formatter.findCorrespondingNode(token)) != null) {
                int lineNumber = node.getLineNumber();
                if (!firstLineInlcuded) {
                    ++lineNumber;
                }
                while (lineNumber <= node.getLastLineNumber()) {
                    if (this.isLastClosureArg(lineNumber - 1, node)) break;
                    int n = lineNumber - 1;
                    this.tempIndentation[n] = this.tempIndentation[n] + indent;
                    this.lineInd.setMultilineIndentation(lineNumber, true);
                    ++lineNumber;
                }
            }
        }
    }

    private boolean isLastClosureArg(int line, ASTNode node) {
        Token token;
        block4: {
            try {
                token = this.tokens.getTokenFrom(this.tokens.getDocument().getLineOffset(line));
                if (token != null) break block4;
                return false;
            }
            catch (Throwable e) {
                GroovyCore.logException("internal error", e);
                return false;
            }
        }
        if ("{".equals(token.getText())) {
            ASTNode nestedNode = this.formatter.findCorrespondingNode(token);
            return node.getEnd() == nestedNode.getEnd();
        }
        return false;
    }

    private void setAdditionalIndentation(Token t) throws BadLocationException {
        this.setAdditionalIndentation(t, 1, true);
    }

    public LineIndentations getLineIndentations() {
        return this.lineInd;
    }

    private String formatMultilineComment(String str, int ind) throws BadLocationException {
        String string = str;
        Matcher m = Pattern.compile("(\n|\r|\r\n)\\s*", 8).matcher(string);
        string = m.replaceAll(String.valueOf(this.formatter.getNewLine()) + this.formatter.getLeadingGap(ind) + " ");
        return string;
    }
}

