/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

public class FormatterPreferencesOnStore
implements IFormatterPreferences {
    private boolean useTabs;
    private int tabSize;
    private int indentSize;
    private int indentationMultiline;
    private int bracesStart;
    private int bracesEnd;
    private int maxLineLength;
    private boolean smartPaste;
    private boolean indentEmptyLines;
    private boolean removeUnnecessarySemicolons;
    private int longListLength;

    public FormatterPreferencesOnStore(IPreferenceStore preferences) {
        if (preferences == null) {
            preferences = new PreferenceStore();
        }
        this.refresh(preferences);
    }

    protected void refresh(IPreferenceStore preferences) {
        this.indentEmptyLines = false;
        String pIndentEmpty = preferences.getString("org.eclipse.jdt.core.formatter.indent_empty_lines");
        if (pIndentEmpty != null) {
            this.indentEmptyLines = pIndentEmpty.equals("true");
        }
        this.bracesStart = 0;
        String pBracesStart = preferences.getString("groovy.formatter.braces.start");
        if (pBracesStart != null && pBracesStart.equals("next")) {
            this.bracesStart = 1;
        }
        this.bracesEnd = 1;
        String pBracesEnd = preferences.getString("groovy.formatter.braces.end");
        if (pBracesEnd != null && pBracesEnd.equals("same")) {
            this.bracesEnd = 0;
        }
        this.tabSize = 4;
        int pTabSize = preferences.getInt("org.eclipse.jdt.core.formatter.tabulation.size");
        if (pTabSize != 0) {
            this.tabSize = pTabSize;
        }
        this.indentSize = 4;
        int pIndentSize = preferences.getInt("org.eclipse.jdt.core.formatter.indentation.size");
        if (pIndentSize != 0) {
            this.indentSize = pIndentSize;
        }
        this.useTabs = true;
        String pTab = preferences.getString("org.eclipse.jdt.core.formatter.tabulation.char");
        if (pTab != null) {
            if (pTab.equals("space")) {
                this.useTabs = false;
                this.indentSize = this.tabSize;
            } else if (pTab.equals("tab")) {
                this.useTabs = true;
                this.indentSize = this.tabSize;
            } else if (pTab.equals("mixed")) {
                this.useTabs = true;
            }
        }
        this.indentationMultiline = 2;
        int pIndeMulti = preferences.getInt("groovy.formatter.multiline.indentation");
        if (pIndeMulti != 0) {
            this.indentationMultiline = pIndeMulti;
        }
        int pMaxLine = preferences.getInt("groovy.formatter.line.maxlength");
        this.maxLineLength = 80;
        if (pMaxLine != 0) {
            this.maxLineLength = pMaxLine;
        }
        String pSmartPaste = preferences.getString("smartPaste");
        this.smartPaste = true;
        if ("true".equals(pSmartPaste)) {
            this.smartPaste = true;
        } else if ("false".equals(pSmartPaste)) {
            this.smartPaste = false;
        }
        this.removeUnnecessarySemicolons = false;
        String pRemoveUnnecessarySemicolons = preferences.getString("groovy.formatter.remove.unnecessary.semicolons");
        if (pRemoveUnnecessarySemicolons != null) {
            this.removeUnnecessarySemicolons = pRemoveUnnecessarySemicolons.equals("true");
        }
        this.longListLength = 30;
        int pLongListLength = preferences.getInt("groovy.formatter.longListLength");
        if (pLongListLength > 0) {
            this.longListLength = pLongListLength;
        }
    }

    @Override
    public int getIndentationMultiline() {
        return this.indentationMultiline;
    }

    @Override
    public int getBracesStart() {
        return this.bracesStart;
    }

    @Override
    public boolean useTabs() {
        return this.useTabs;
    }

    @Override
    public int getBracesEnd() {
        return this.bracesEnd;
    }

    @Override
    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    @Override
    public boolean isSmartPaste() {
        return this.smartPaste;
    }

    @Override
    public boolean isIndentEmptyLines() {
        return this.indentEmptyLines;
    }

    @Override
    public int getIndentationSize() {
        return this.indentSize;
    }

    @Override
    public int getTabSize() {
        return this.tabSize;
    }

    @Override
    public boolean isRemoveUnnecessarySemicolons() {
        return this.removeUnnecessarySemicolons;
    }

    @Override
    public int getLongListLength() {
        return this.longListLength;
    }
}

