/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rename;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextSelection;

public class CandidateCollector {
    protected ITextSelection selection;
    protected GroovyCompilationUnit unit;
    protected ISourceReference refactoringTarget;
    private boolean isValid = true;

    public CandidateCollector(GroovyCompilationUnit unit, ITextSelection selection) {
        this.unit = unit;
        this.selection = selection;
    }

    public ISourceReference getRefactoringTarget() {
        if (this.isValid && this.refactoringTarget == null) {
            try {
                IJavaElement[] element = this.unit.codeSelect(this.selection.getOffset(), this.selection.getLength());
                if (element != null && element.length > 0 && element[0] instanceof ISourceReference) {
                    this.refactoringTarget = (ISourceReference)((Object)element[0]);
                } else {
                    this.isValid = false;
                }
            }
            catch (JavaModelException e) {
                GroovyCore.logException("Exception finding element at offset " + this.selection.getOffset() + " in compilation unit " + this.unit.getElementName(), (Throwable)((Object)e));
            }
        }
        return this.refactoringTarget;
    }
}

