/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.compiler;

import java.util.Hashtable;
import java.util.Iterator;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.compiler.MockCompilationUnit;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnitResolver;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;

public class GroovySnippetCompiler {
    private INameEnvironment nameEnvironment;

    public GroovySnippetCompiler(JavaProject project) {
        try {
            this.nameEnvironment = new SearchableEnvironment(project, null, false);
        }
        catch (JavaModelException e) {
            GroovyCore.logException("Problem initializing snippet compiler for project " + project.getElementName(), (Throwable)((Object)e));
        }
    }

    public ModuleNode compile(String source, String sourcePath) {
        GroovyCompilationUnitDeclaration decl = this.internalCompile(source, sourcePath);
        ModuleNode node = decl.getModuleNode();
        for (ClassNode classNode : node.getClasses()) {
            Iterator<MethodNode> methodIter = classNode.getMethods().iterator();
            while (methodIter.hasNext()) {
                MethodNode method = methodIter.next();
                if (!GroovyUtils.isSynthetic(method)) continue;
                methodIter.remove();
            }
        }
        return node;
    }

    public CompilationResult compileForErrors(String source, String sourcePath) {
        GroovyCompilationUnitDeclaration unit = this.internalCompile(source, sourcePath);
        return unit.compilationResult();
    }

    private GroovyCompilationUnitDeclaration internalCompile(String source, String sourcePath) {
        if (sourcePath == null) {
            sourcePath = "Nothing.groovy";
        } else if (!ContentTypeUtils.isGroovyLikeFileName(sourcePath)) {
            sourcePath = sourcePath.concat(".groovy");
        }
        Hashtable<String, String> options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "enabled");
        CompilationUnitResolver compiler = new CompilationUnitResolver(this.nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(options), result -> {}, (IProblemFactory)new DefaultProblemFactory(), null, true);
        GroovyCompilationUnitDeclaration decl = (GroovyCompilationUnitDeclaration)((Compiler)compiler).resolve(new MockCompilationUnit(source.toCharArray(), sourcePath.toCharArray()), true, false, false);
        return decl;
    }

    public void cleanup() {
        this.nameEnvironment.cleanup();
    }

    public ModuleNode compile(String source) {
        return this.compile(source, null);
    }
}

