/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.builder;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.GroovyCoreActivator;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GroovyClasspathContainer
implements IClasspathContainer {
    public static final String DESC = "Groovy Libraries";
    public static final IPath CONTAINER_ID = new Path("GROOVY_SUPPORT");
    public static final IClasspathAttribute MINIMAL_ATTRIBUTE = JavaCore.newClasspathAttribute("minimal", "true");
    private IJavaProject project;
    private IClasspathEntry[] entries;

    public GroovyClasspathContainer(IJavaProject project) {
        this.project = project;
    }

    @Override
    public synchronized IClasspathEntry[] getClasspathEntries() {
        if (this.entries == null) {
            this.updateEntries();
        }
        return this.entries;
    }

    @Override
    public String getDescription() {
        return DESC;
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public IPath getPath() {
        return CONTAINER_ID;
    }

    synchronized void reset() {
        this.entries = null;
    }

    private void updateEntries() {
        try {
            boolean minimalLibraries = GroovyClasspathContainer.hasMinimalAttribute(GroovyRuntime.getGroovyClasspathEntry(this.project));
            LinkedHashSet<IPath> libraries = new LinkedHashSet<IPath>();
            libraries.add(CompilerUtils.getExportedGroovyAllJar());
            if (!minimalLibraries) {
                libraries.addAll(CompilerUtils.getExtraJarsForClasspath());
            }
            ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>(libraries.size());
            for (IPath jarPath : libraries) {
                IPath srcPath = CompilerUtils.getJarInGroovyLib(String.valueOf(jarPath.removeFileExtension().lastSegment().replace("-indy", "")) + "-sources.jar");
                IPath docPath = CompilerUtils.getJarInGroovyLib(String.valueOf(jarPath.removeFileExtension().lastSegment().replace("-indy", "")) + "-javadoc.jar");
                ArrayList<IClasspathAttribute> attrs = new ArrayList<IClasspathAttribute>();
                if (jarPath.lastSegment().startsWith("groovy-test")) {
                    attrs.add(GroovyClasspathContainer.newIsTestClasspathAttribute());
                }
                if (docPath != null) {
                    attrs.add(GroovyClasspathContainer.newJavadocLocationClasspathAttribute(docPath));
                }
                cpEntries.add(JavaCore.newLibraryEntry(jarPath, srcPath, null, null, attrs.toArray(new IClasspathAttribute[attrs.size()]), true));
            }
            if (!minimalLibraries && this.useGroovyLibs()) {
                cpEntries.addAll(GroovyClasspathContainer.getGroovyJarsInDotGroovyLib());
            }
            this.entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
        }
        catch (Exception e) {
            GroovyCore.logException("Problem finding Groovy runtime", e);
            this.entries = new IClasspathEntry[0];
        }
    }

    private boolean useGroovyLibs() {
        ProjectScope projectScope = new ProjectScope(this.project.getProject());
        IEclipsePreferences projectNode = projectScope.getNode("org.codehaus.groovy.eclipse.core");
        String val = projectNode.get("groovy.classpath.use.groovy,lib", "default");
        if (val.equals(Boolean.TRUE.toString())) {
            return true;
        }
        if (val.equals(Boolean.FALSE.toString())) {
            return false;
        }
        return GroovyCoreActivator.getDefault().getPreference("groovy.classpath.use.groovy.lib.global", true);
    }

    private static Collection<IClasspathEntry> getGroovyJarsInDotGroovyLib() {
        File[] jars = CompilerUtils.findJarsInDotGroovyLocation();
        Predicate<File> isSources = file -> file.getName().endsWith("-sources.jar");
        Predicate<File> isJavadoc = file -> file.getName().endsWith("-javadoc.jar");
        return Arrays.stream(jars).filter(isSources.or(isJavadoc).negate()).map(file -> {
            IClasspathAttribute[] iClasspathAttributeArray;
            Path jarPath = new Path(file.getAbsolutePath());
            String srcName = String.valueOf(jarPath.removeFileExtension().lastSegment().replace("-indy", "")) + "-sources.jar";
            String docName = String.valueOf(jarPath.removeFileExtension().lastSegment().replace("-indy", "")) + "-javadoc.jar";
            IPath srcPath = Arrays.stream(jars).filter(isSources.and(srcFile -> srcFile.getName().equals(srcName))).findFirst().map(srcFile -> new Path(srcFile.getAbsolutePath())).orElse(null);
            IPath docPath = Arrays.stream(jars).filter(isJavadoc.and(docFile -> docFile.getName().equals(docName))).findFirst().map(docFile -> new Path(docFile.getAbsolutePath())).orElse(null);
            if (docPath == null) {
                iClasspathAttributeArray = null;
            } else {
                IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
                iClasspathAttributeArray = iClasspathAttributeArray2;
                iClasspathAttributeArray2[0] = GroovyClasspathContainer.newJavadocLocationClasspathAttribute(docPath);
            }
            IClasspathAttribute[] icas = iClasspathAttributeArray;
            return JavaCore.newLibraryEntry((IPath)jarPath, srcPath, null, null, icas, true);
        }).collect(Collectors.toList());
    }

    public static boolean hasMinimalAttribute(IClasspathEntry entry) {
        if (entry != null) {
            IClasspathAttribute[] extraAttributes;
            IClasspathAttribute[] iClasspathAttributeArray = extraAttributes = entry.getExtraAttributes();
            int n = extraAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attribute = iClasspathAttributeArray[n2];
                if (attribute.getName().equals(MINIMAL_ATTRIBUTE.getName())) {
                    return Boolean.parseBoolean(attribute.getValue());
                }
                ++n2;
            }
        }
        return false;
    }

    private static IClasspathAttribute newIsTestClasspathAttribute() {
        return JavaCore.newClasspathAttribute("test", "true");
    }

    private static IClasspathAttribute newJavadocLocationClasspathAttribute(IPath docPath) {
        try {
            String name = "javadoc_location";
            String path = docPath.toFile().toURI().toURL().toString();
            return JavaCore.newClasspathAttribute(name, "jar:" + path + "!/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

