/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Joiner;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.io.Resources;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.pde.JdkConfig;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class PdeBuildProperties {
    private String content = PdeBuildProperties.rawFile();

    static String rawFile() {
        return (String)Errors.rethrow().get(() -> {
            URL url = PdeBuildProperties.class.getResource("template.build.properties");
            System.out.println("url=" + url);
            byte[] content = Resources.toByteArray((URL)url);
            return new String(content, StandardCharsets.UTF_8);
        });
    }

    String getContent() {
        return this.content;
    }

    void setBasePlatform(SwtPlatform host) {
        this.setProp("baseos", host.getOs());
        this.setProp("basews", host.getWs());
        this.setProp("basearch", host.getArch());
    }

    void setBuildDirectory(File buildDir) {
        this.setProp("buildDirectory", buildDir.getAbsolutePath());
    }

    void setConfigs(Collection<SwtPlatform> platforms) {
        String value = platforms.stream().map(plat -> plat.getOs() + "," + plat.getWs() + "," + plat.getArch()).collect(Collectors.joining(" & \n"));
        this.setProp("configs", value);
    }

    private static String getSep() {
        return System.getProperty("path.separator");
    }

    void setPluginPaths(List<File> pluginPaths) {
        this.setProp("pluginPath", Joiner.on((String)PdeBuildProperties.getSep()).join(pluginPaths));
    }

    void setJDK(JdkConfig jdk) {
        String jdkLibs = jdk.getJdkLibs().stream().map(File::getAbsolutePath).collect(Collectors.joining(PdeBuildProperties.getSep()));
        this.setTag("JRE", jdk.name + "=\"" + jdkLibs + "\"");
        this.setProp("javacSource", jdk.source);
        this.setProp("javacTarget", jdk.target);
    }

    private void setTag(String tag, String val) {
        this.replace(tag, val);
    }

    void setProp(String key, String value) {
        if (this.content.contains(PdeBuildProperties.tag_(key))) {
            this.replace(key, key + "=" + value);
        } else {
            if (!this.content.endsWith("\n")) {
                this.content = this.content + "\n";
            }
            this.content = this.content + key + "=" + PdeBuildProperties.val_(value);
            this.content = this.content + "\n";
        }
    }

    private void replace(String tag, String value) {
        String modified = this.content.replace(PdeBuildProperties.tag_(tag), PdeBuildProperties.val_(value));
        Preconditions.checkState((!modified.equals(this.content) ? 1 : 0) != 0, (String)"No effect: %s to %s", (Object[])new Object[]{tag, value});
        this.content = modified;
    }

    private static String tag_(String key) {
        return "#{" + key + "}";
    }

    private static String val_(String val) {
        return val.replace("\\", "/").replace("\n", "\\\n");
    }
}

