/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipserunner;

import com.diffplug.common.base.Joiner;
import com.diffplug.common.collect.Iterables;
import com.diffplug.common.collect.ListMultimap;
import com.diffplug.common.collect.Multimaps;
import com.diffplug.common.io.Files;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.eclipserunner.EclipseRunner;
import groovy.util.Node;
import groovy.xml.XmlUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public class EclipseApp {
    protected final ListMultimap<String, String> args = Multimaps.newListMultimap(new LinkedHashMap(), ArrayList::new);

    public EclipseApp(String application) {
        this.addArg("application", application);
    }

    public void runUsing(EclipseRunner runner) throws Exception {
        runner.run(this.toArgList());
    }

    public String completeState() {
        StringBuilder builder = new StringBuilder();
        this.args.asMap().forEach((key, values) -> {
            boolean valuesIsEmptyString;
            builder.append("-" + key);
            boolean bl = valuesIsEmptyString = values.size() == 1 && ((String)Iterables.getOnlyElement((Iterable)values)).isEmpty();
            if (!valuesIsEmptyString) {
                builder.append(' ');
                builder.append(Joiner.on((String)",").join((Iterable)values));
            }
            builder.append('\n');
        });
        return builder.toString();
    }

    public String toString() {
        return this.completeState();
    }

    public void addArg(String key, String value) {
        this.args.put((Object)key, (Object)FileMisc.quote(value));
    }

    public void addArg(String key) {
        if (!this.args.get((Object)key).equals(Collections.singletonList(""))) {
            this.args.put((Object)key, (Object)"");
        }
    }

    protected List<String> toArgList() {
        ArrayList<String> argList = new ArrayList<String>(this.args.size() * 2);
        this.args.asMap().forEach((key, values) -> {
            boolean valuesIsEmptyString;
            argList.add("-" + key);
            boolean bl = valuesIsEmptyString = values.size() == 1 && ((String)Iterables.getOnlyElement((Iterable)values)).isEmpty();
            if (!valuesIsEmptyString) {
                argList.add(Joiner.on((String)",").join((Iterable)values));
            }
        });
        return argList;
    }

    public void clean() {
        this.addArg("clean");
    }

    public void consolelog() {
        this.addArg("consolelog");
    }

    public static class AntRunner
    extends EclipseApp {
        public static final String ID = "org.eclipse.ant.core.antRunner";
        String buildXml = "NOBODY CALLED EclipseApp.AntRunner.setTask";

        public AntRunner() {
            super(ID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runUsing(EclipseRunner runner) throws Exception {
            File tempFile = File.createTempFile("goomph-ant-build", ".xml");
            Files.write((byte[])this.buildXml().getBytes(StandardCharsets.UTF_8), (File)tempFile);
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.addAll(this.toArgList());
                args.add("-buildfile");
                args.add(tempFile.getAbsolutePath());
                runner.run(args);
            }
            finally {
                FileMisc.forceDelete(tempFile);
            }
        }

        public void setTask(Node taskNode) {
            Node project = new Node(null, (Object)"project");
            project.append(taskNode);
            this.buildXml = FileMisc.toUnixNewline(XmlUtil.serialize((Node)project));
        }

        public void define(String key, String value) {
            this.addArg("D" + key + "=" + FileMisc.quote(value));
        }

        public void defineToFile(String key, File value) {
            this.define(key, value.getAbsolutePath());
        }

        protected String buildXml() {
            return Objects.requireNonNull(this.buildXml);
        }

        @Override
        public String completeState() {
            StringBuilder builder = new StringBuilder();
            builder.append("### ARGS ###\n");
            builder.append(super.completeState());
            builder.append("\n### BUILD.XML ###\n");
            builder.append(this.buildXml());
            return builder.toString();
        }
    }
}

