/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.check.naming;

import com.devonfw.ide.sonarqube.common.impl.check.naming.DevonNamingConventionClassExtendsClassCheck;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;

@Rule(key="N5", name="devonfw Naming Check of Use-Case Implementations", priority=Priority.CRITICAL, tags={"architecture-violation", "devonfw", "naming"})
public class DevonNamingConventionClassExtendsClassUcImplCheck
extends DevonNamingConventionClassExtendsClassCheck {
    private static final String DESIRED_SUPERCLASS_NAME = "AbstractUc";
    private List<String> superInterfacesNames;

    public DevonNamingConventionClassExtendsClassUcImplCheck() {
        super("Uc.*Impl");
    }

    @Override
    protected boolean checkClassNameAndCreateIssue(ClassTree tree, JavaFileScannerContext context) {
        this.superInterfacesNames = this.getSuperInterfacesNames(tree);
        String desiredSuperInterfaceName = this.className.replaceAll("Impl$", "");
        if (!super.checkClassNameAndCreateIssue(tree, context) && !DevonNamingConventionClassExtendsClassUcImplCheck.isAbstract(tree) && this.isImplementingCorrectInterface(desiredSuperInterfaceName)) {
            return false;
        }
        context.addIssue(tree.openBraceToken().line(), (JavaCheck)this, "Non-abstract use-case classes must begin with Uc, end with Impl and implement an interface with the same name except the suffix Impl.");
        return true;
    }

    protected boolean isImplementingCorrectInterface(String superInterface) {
        for (String name : this.superInterfacesNames) {
            if (!superInterface.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isSuperClassMatching() {
        if (DESIRED_SUPERCLASS_NAME.equals(this.superClassName)) {
            return true;
        }
        return super.isSuperClassMatching();
    }
}

