/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.api.config;

import com.devonfw.ide.sonarqube.common.api.config.Component;
import com.devonfw.ide.sonarqube.common.api.config.Configuration;
import com.devonfw.ide.sonarqube.common.api.config.Node;
import com.devonfw.ide.sonarqube.common.api.config.Packages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Architecture {
    private List<Component> components;
    private Map<String, Component> componentMap;
    private Packages packages;

    public List<Component> getComponents() {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        return this.components;
    }

    public Component getComponent(String name) {
        if (this.componentMap != null) {
            return this.componentMap.get(name);
        }
        for (Component component : this.getComponents()) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void setPackages(Packages packages) {
        this.packages = packages;
    }

    public Packages getPackages() {
        return this.packages;
    }

    public static Packages getPackages(Architecture architecture) {
        Packages packages = null;
        if (architecture != null) {
            packages = architecture.getPackages();
        }
        if (packages == null) {
            packages = Packages.getDefault();
        }
        return packages;
    }

    void initialize(Configuration configuration) {
        this.componentMap = new HashMap<String, Component>();
        for (Component component : this.components) {
            Component duplicate = this.componentMap.put(component.getName(), component);
            if (duplicate == null) continue;
            configuration.status().addError("Duplicate architecture component '" + component.getName() + "'.");
        }
        Component general = this.componentMap.get("general");
        if (general == null) {
            general = new Component("general");
            this.componentMap.put("general", general);
        }
        Node<String> root = new Node<String>("components");
        Component app = this.componentMap.get("app");
        if (app == null) {
            app = new Component("app");
            this.componentMap.put("app", app);
        }
        this.initialize(app, root, configuration);
        for (Component component : this.components) {
            this.initialize(component, root, configuration);
            app.allDependencies.add(component.getName());
        }
        for (Component component : this.componentMap.values()) {
            Set<String> nonTransitiveDependencies = component.getNonTransitiveDependencies();
            if (nonTransitiveDependencies == null) continue;
            component.allDependencies.addAll(nonTransitiveDependencies);
        }
    }

    private void initialize(Component component, Node<String> parentNode, Configuration configuration) {
        String name = component.getName();
        Node<String> componentNode = parentNode.createChild(name);
        if (component.allDependencies != null) {
            Node<String> duplicate = parentNode.find(name);
            if (duplicate != null) {
                configuration.status().addError("Cyclic dependency detected: " + componentNode);
            }
            return;
        }
        component.allDependencies = new HashSet<String>(component.getDependencies());
        for (String dependency : component.getDependencies()) {
            this.initializeDependency(component, configuration, name, componentNode, dependency);
        }
        if (!component.getName().equals("general") && !component.getDependencies().contains("general")) {
            this.initializeDependency(component, configuration, name, componentNode, "general");
            component.allDependencies.add("general");
        }
    }

    private void initializeDependency(Component component, Configuration configuration, String name, Node<String> componentNode, String dependency) {
        if (dependency.contains(".")) {
            component.allDependencies.add(dependency);
        } else {
            Component dependentComponent = this.componentMap.get(dependency);
            if (dependentComponent == null) {
                configuration.status().addError("Component '" + name + "' has dependency '" + dependency + "' but no such component is defined.");
            } else {
                this.initialize(dependentComponent, componentNode, configuration);
                component.allDependencies.addAll(dependentComponent.allDependencies);
            }
        }
    }
}

