/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.service.common.impl;

import com.devonfw.module.basic.common.api.config.ConfigProperties;
import com.devonfw.module.basic.common.api.config.SimpleConfigProperties;
import com.devonfw.module.service.common.api.client.ServiceClientFactory;
import com.devonfw.module.service.common.api.client.discovery.ServiceDiscoverer;
import com.devonfw.module.service.common.api.header.ServiceHeaderCustomizer;
import com.devonfw.module.service.common.api.sync.SyncServiceClientFactory;
import com.devonfw.module.service.common.base.context.ServiceContextImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;

public class ServiceClientFactoryImpl
implements ServiceClientFactory {
    private Collection<SyncServiceClientFactory> syncServiceClientFactories;
    private Collection<ServiceDiscoverer> serviceDiscoverers;
    private Collection<ServiceHeaderCustomizer> serviceHeaderCustomizers;

    @Inject
    public void setSyncServiceClientFactories(Collection<SyncServiceClientFactory> syncServiceClientFactories) {
        this.syncServiceClientFactories = syncServiceClientFactories;
    }

    @Inject
    public void setServiceDiscoverers(Collection<ServiceDiscoverer> serviceDiscoverers) {
        this.serviceDiscoverers = serviceDiscoverers;
    }

    @Inject
    public void setServiceHeaderCustomizers(Collection<ServiceHeaderCustomizer> serviceHeaderCustomizers) {
        this.serviceHeaderCustomizers = serviceHeaderCustomizers;
    }

    @Override
    public <S> S create(Class<S> serviceInterface) {
        return this.create(serviceInterface, null);
    }

    @Override
    public <S> S create(Class<S> serviceInterface, Map<String, String> properties) {
        ConfigProperties configPropreties = ConfigProperties.EMPTY;
        if (properties != null && !properties.isEmpty()) {
            configPropreties = SimpleConfigProperties.ofFlatMap(properties);
        }
        ServiceContextImpl<S> context = new ServiceContextImpl<S>(serviceInterface, configPropreties);
        this.discovery(context);
        this.customizeHeaders(context);
        S serviceClient = this.createClient(serviceInterface, context);
        return serviceClient;
    }

    private <S> S createClient(Class<S> serviceInterface, ServiceContextImpl<S> context) {
        SyncServiceClientFactory factory;
        S serviceClient = null;
        Iterator<SyncServiceClientFactory> iterator = this.syncServiceClientFactories.iterator();
        while (iterator.hasNext() && (serviceClient = (S)(factory = iterator.next()).create(context)) == null) {
        }
        if (serviceClient == null) {
            throw new IllegalStateException("Unsuppoerted service type - client could not be created by any factory for " + serviceInterface);
        }
        return serviceClient;
    }

    private <S> void customizeHeaders(ServiceContextImpl<S> context) {
        for (ServiceHeaderCustomizer headerCustomizer : this.serviceHeaderCustomizers) {
            headerCustomizer.addHeaders(context);
        }
    }

    private <S> void discovery(ServiceContextImpl<S> context) {
        if (context.getUrl() != null) {
            return;
        }
        if (this.serviceDiscoverers != null) {
            for (ServiceDiscoverer discoverer : this.serviceDiscoverers) {
                discoverer.discover(context);
                if (context.getUrl() == null) continue;
                break;
            }
        }
        if (context.getUrl() == null) {
            throw new IllegalStateException("Service discovery failed for " + context.getApi());
        }
    }
}

