/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.security.common.impl.accesscontrol;

import com.devonfw.module.security.common.api.accesscontrol.AccessControlSchema;
import com.devonfw.module.security.common.base.accesscontrol.AccessControlSchemaMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlSchemaXmlMapper
implements AccessControlSchemaMapper {
    private static final Logger LOG = LoggerFactory.getLogger(AccessControlSchemaXmlMapper.class);
    private JAXBContext jaxbContext;

    public AccessControlSchemaXmlMapper() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AccessControlSchema.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void write(AccessControlSchema conf, OutputStream out) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.marshal((Object)conf, out);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Marshalling XML failed!", e);
        }
    }

    @Override
    public AccessControlSchema read(InputStream in) {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            ValidationEventHandlerImpl handler = new ValidationEventHandlerImpl();
            unmarshaller.setEventHandler((ValidationEventHandler)handler);
            return (AccessControlSchema)unmarshaller.unmarshal(in);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unmarshalling XML failed!", e);
        }
    }

    public void writeXsd(File outFile) {
        boolean success;
        File folder = outFile.getParentFile();
        if (!folder.isDirectory() && !(success = folder.mkdirs())) {
            throw new IllegalStateException("Failed to create folder " + folder);
        }
        try (FileOutputStream fos = new FileOutputStream(outFile);){
            this.writeXsd(fos);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate and write the XSD schema to " + outFile + "!", e);
        }
    }

    public void writeXsd(final OutputStream out) {
        SchemaOutputResolver sor = new SchemaOutputResolver(){

            public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                StreamResult streamResult = new StreamResult(out);
                streamResult.setSystemId(suggestedFileName);
                return streamResult;
            }
        };
        try {
            this.jaxbContext.generateSchema(sor);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to generate and write the XSD schema!", e);
        }
    }

    protected static class ValidationEventHandlerImpl
    implements ValidationEventHandler {
        public boolean handleEvent(ValidationEvent event) {
            if (event != null) {
                switch (event.getSeverity()) {
                    case 1: 
                    case 2: {
                        throw new IllegalArgumentException(event.toString());
                    }
                    case 0: {
                        LOG.warn(event.toString());
                        break;
                    }
                    default: {
                        LOG.debug(event.toString());
                    }
                }
            }
            return true;
        }
    }
}

