/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.rest.service.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public class RequestParameters {
    private final MultivaluedMap<String, String> parameters;

    public RequestParameters(MultivaluedMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public <T> T get(String key, Class<T> targetType, boolean required) throws WebApplicationException {
        String value = this.get(key);
        if (value == null) {
            if (required) {
                throw new BadRequestException("Missing parameter: " + key);
            }
            Comparable<Boolean> result = null;
            if (targetType.isPrimitive()) {
                if (targetType == Boolean.TYPE) {
                    result = Boolean.FALSE;
                } else if (targetType == Integer.TYPE) {
                    result = 0;
                } else if (targetType == Long.TYPE) {
                    result = 0L;
                } else if (targetType == Double.TYPE) {
                    result = 0.0;
                } else if (targetType == Float.TYPE) {
                    result = Float.valueOf(0.0f);
                } else if (targetType == Byte.TYPE) {
                    result = (byte)0;
                } else if (targetType == Short.TYPE) {
                    result = (short)0;
                } else if (targetType == Character.TYPE) {
                    result = Character.valueOf('\u0000');
                }
            }
            return (T)result;
        }
        try {
            return this.convertValue(value, targetType);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BadRequestException("Failed to convert '" + value + "' to type " + targetType);
        }
    }

    protected <T> T convertValue(String value, Class<T> targetType) throws ParseException {
        Object result;
        if (value == null) {
            return null;
        }
        if (targetType == String.class) {
            result = value;
        } else {
            if (targetType.isEnum()) {
                for (T instance : targetType.getEnumConstants()) {
                    Enum e = (Enum)instance;
                    if (!e.name().equalsIgnoreCase(value)) continue;
                    return instance;
                }
                throw new IllegalArgumentException("Enum constant not found!");
            }
            if (targetType == Boolean.TYPE || targetType == Boolean.class) {
                result = Boolean.parseBoolean(value);
            } else if (targetType == Integer.TYPE || targetType == Integer.class) {
                result = Integer.valueOf(value);
            } else if (targetType == Long.TYPE || targetType == Long.class) {
                result = Long.valueOf(value);
            } else if (targetType == Double.TYPE || targetType == Double.class) {
                result = Double.valueOf(value);
            } else if (targetType == Float.TYPE || targetType == Float.class) {
                result = Float.valueOf(value);
            } else if (targetType == Short.TYPE || targetType == Short.class) {
                result = Short.valueOf(value);
            } else if (targetType == Byte.TYPE || targetType == Byte.class) {
                result = Byte.valueOf(value);
            } else if (targetType == BigDecimal.class) {
                result = new BigDecimal(value);
            } else if (targetType == BigInteger.class) {
                result = new BigInteger(value);
            } else if (targetType == Date.class) {
                result = new SimpleDateFormat("YYYY-MM-dd'T'HH:mm:ss").parseObject(value);
            } else {
                throw new InternalServerErrorException("Unsupported type " + targetType);
            }
        }
        return (T)result;
    }

    public String get(String key) throws BadRequestException {
        List list = (List)this.parameters.get((Object)key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new BadRequestException("Duplicate parameter: " + key);
        }
        return (String)list.get(0);
    }

    public String getFirst(String key) {
        return (String)this.parameters.getFirst((Object)key);
    }

    public List<String> getList(String key) {
        List<String> list = (List<String>)this.parameters.get((Object)key);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public static RequestParameters fromQuery(UriInfo uriInfo) {
        return new RequestParameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
    }

    public static RequestParameters fromPath(UriInfo uriInfo) {
        return new RequestParameters((MultivaluedMap<String, String>)uriInfo.getPathParameters());
    }
}

