/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.jpa.dataaccess.impl.data;

import com.devonfw.module.basic.common.api.RevisionMetadata;
import com.devonfw.module.basic.common.api.entity.RevisionedEntity;
import com.devonfw.module.jpa.dataaccess.api.AdvancedRevisionEntity;
import com.devonfw.module.jpa.dataaccess.api.JpaHelper;
import com.devonfw.module.jpa.dataaccess.api.QueryUtil;
import com.devonfw.module.jpa.dataaccess.api.data.GenericRevisionedRepository;
import com.devonfw.module.jpa.dataaccess.impl.LazyRevisionMetadata;
import com.devonfw.module.jpa.dataaccess.impl.data.GenericRepositoryImpl;
import com.querydsl.core.alias.Alias;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;

public class GenericRevisionedRepositoryImpl<E, ID extends Serializable>
extends GenericRepositoryImpl<E, ID>
implements GenericRevisionedRepository<E, ID> {
    public GenericRevisionedRepositoryImpl(JpaEntityInformation<E, ID> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
    }

    @Override
    public E find(ID id, Number revision) {
        AuditReader auditReader = AuditReaderFactory.get((EntityManager)this.entityManager);
        Object entity = auditReader.find(this.entityInformation.getJavaType(), id, revision);
        if (entity instanceof RevisionedEntity) {
            ((RevisionedEntity)entity).setRevision(revision);
        }
        return (E)entity;
    }

    @Override
    public List<RevisionMetadata> getRevisionHistoryMetadata(ID id, boolean lazy) {
        AuditReader auditReader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisionList = auditReader.getRevisions(this.getEntityClass(), id);
        if (revisionList.isEmpty()) {
            return Collections.emptyList();
        }
        if (lazy) {
            ArrayList<RevisionMetadata> result = new ArrayList<RevisionMetadata>(revisionList.size());
            for (Number revision : revisionList) {
                Long revisionLong = revision.longValue();
                result.add((RevisionMetadata)new LazyRevisionMetadata(this.entityManager, revisionLong));
            }
            return result;
        }
        AdvancedRevisionEntity rev = (AdvancedRevisionEntity)Alias.alias(AdvancedRevisionEntity.class);
        JPAQuery query = (JPAQuery)new JPAQuery(this.entityManager).from((EntityPath)Alias.$((Object)rev));
        List revList = revisionList;
        QueryUtil.get().whereIn(query, (SimpleExpression)Alias.$((Long)rev.getId()), (Collection)revList);
        query.orderBy(Alias.$((Long)rev.getId()).asc());
        List resultList = query.fetch();
        return resultList.stream().map(x -> JpaHelper.asRevisionMetaData((AdvancedRevisionEntity)x)).collect(Collectors.toList());
    }

    @Override
    public RevisionMetadata getLastRevisionHistoryMetadata(ID id) {
        AuditReader auditReader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisionList = auditReader.getRevisions(this.getEntityClass(), id);
        if (revisionList.isEmpty()) {
            return null;
        }
        Number lastRevision = (Number)revisionList.get(revisionList.size() - 1);
        AdvancedRevisionEntity revisionEntity = (AdvancedRevisionEntity)this.entityManager.find(AdvancedRevisionEntity.class, (Object)lastRevision);
        if (revisionEntity == null) {
            throw new IllegalStateException("Could not find AdvancedRevisionEntity for ID '" + id + "'.");
        }
        return JpaHelper.asRevisionMetaData((AdvancedRevisionEntity)revisionEntity);
    }
}

