/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.cxf.common.impl.server.rest;

import com.devonfw.module.json.common.base.ObjectMapperFactory;
import com.devonfw.module.rest.common.api.RestService;
import com.devonfw.module.rest.service.impl.RestServiceExceptionFacade;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CxfServerRestAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CxfServerRestAutoConfiguration.class);
    @Value(value="${security.expose.error.details:false}")
    private boolean exposeInternalErrorDetails;
    @Value(value="${service.rest.find-by-name:true}")
    private boolean findRestServicesByName;
    @Inject
    private ConfigurableApplicationContext applicationContext;
    @Inject
    private SpringBus springBus;
    @Inject
    private ObjectMapperFactory objectMapperFactory;

    @Bean
    public Server jaxRsServer() {
        List<Object> restServices = this.findRestServices();
        if (restServices.isEmpty()) {
            LOG.info("No REST Services have been found. Rest Endpoint will not be enabled in CXF.");
            return null;
        }
        List<Object> providers = this.findRestProviders();
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        factory.setBus((Bus)this.springBus);
        factory.setAddress("/rest");
        factory.setServiceBeans(restServices);
        factory.setProviders(providers);
        return factory.create();
    }

    @Bean
    public JacksonJsonProvider jacksonJsonProvider() {
        return new JacksonJsonProvider(this.objectMapperFactory.createInstance());
    }

    @Bean
    public RestServiceExceptionFacade restServiceExceptionFacade() {
        RestServiceExceptionFacade exceptionFacade = new RestServiceExceptionFacade();
        exceptionFacade.setExposeInternalErrorDetails(this.exposeInternalErrorDetails);
        return exceptionFacade;
    }

    protected List<Object> findRestProviders() {
        return new ArrayList<Object>(this.applicationContext.getBeansWithAnnotation(Provider.class).values());
    }

    protected List<Object> findRestServices() {
        if (this.findRestServicesByName) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
                if (!beanName.contains("RestService")) continue;
                result.add(this.applicationContext.getBean(beanName));
            }
            return result;
        }
        return new ArrayList<Object>(this.applicationContext.getBeansOfType(RestService.class).values());
    }
}

