/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.basic.common.api.query;

public enum LikePatternSyntax {
    GLOB('*', '?'),
    SQL('%', '_');

    public static final char ESCAPE = '\\';
    private final char any;
    private final char single;

    private LikePatternSyntax(char any, char single) {
        this.any = any;
        this.single = single;
    }

    public char getAny() {
        return this.any;
    }

    public char getSingle() {
        return this.single;
    }

    public String convert(String pattern, LikePatternSyntax syntax) {
        return this.convert(pattern, syntax, false);
    }

    public String convert(String pattern, LikePatternSyntax syntax, boolean matchSubstring) {
        if (pattern == null || pattern.isEmpty()) {
            if (matchSubstring) {
                return Character.toString(this.any);
            }
            return pattern;
        }
        if (this == syntax) {
            String result = pattern;
            if (matchSubstring) {
                int lastIndex;
                if (pattern.charAt(0) != this.any) {
                    result = this.any + result;
                }
                if (pattern.charAt(lastIndex = pattern.length() - 1) != this.any || lastIndex > 0 && pattern.charAt(lastIndex - 1) == '\\') {
                    result = result + this.any;
                }
            }
            return result;
        }
        int length = pattern.length();
        StringBuilder sb = new StringBuilder(length + 8);
        boolean lastWildcardAny = false;
        for (int i = 0; i < length; ++i) {
            lastWildcardAny = false;
            char c = pattern.charAt(i);
            if (c == syntax.any) {
                c = this.any;
                lastWildcardAny = true;
            } else if (c == syntax.single) {
                c = this.single;
            } else if (c == this.any || c == this.single || c == '\\') {
                if (i == 0 && matchSubstring) {
                    sb.append(this.any);
                }
                sb.append('\\');
            }
            if (matchSubstring && i == 0 && !lastWildcardAny) {
                sb.append(this.any);
            }
            sb.append(c);
        }
        if (matchSubstring && !lastWildcardAny) {
            sb.append(this.any);
        }
        return sb.toString();
    }

    public static LikePatternSyntax autoDetect(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return null;
        }
        for (LikePatternSyntax syntax : LikePatternSyntax.values()) {
            if (pattern.indexOf(syntax.any) > 0) {
                return syntax;
            }
            if (pattern.indexOf(syntax.single) <= 0) continue;
            return syntax;
        }
        return null;
    }
}

