/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.util;

import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SystemUtil.class);
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static Path MVN_EXEC = null;

    /*
     * Exception decompiling
     */
    public static String determineLineDelimiter(Path path, String targetCharset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 25[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void emptyReader(InputStreamReader reader) throws IOException {
        while (reader.ready()) {
            reader.read();
        }
    }

    public static Path determineMvnPath() {
        if (MVN_EXEC != null) {
            return MVN_EXEC;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (OS.contains("win")) {
            processBuilder.command("where", "mvn");
        } else {
            processBuilder.command("which", "mvn");
        }
        String mvnExecPath = null;
        try {
            Process process = processBuilder.start();
            try (InputStream in = process.getInputStream();
                 InputStreamReader inr = new InputStreamReader(in);
                 BufferedReader reader = new BufferedReader(inr);){
                int retVal;
                List<String> foundEntries = reader.lines().collect(Collectors.toList());
                LOG.debug("Found following executables: ");
                foundEntries.forEach(e -> LOG.debug("  - {}", e));
                if (foundEntries.size() > 0) {
                    if (foundEntries.size() > 1 && OS.contains("win")) {
                        Pattern p = Pattern.compile(".+mvn\\.(bat|cmd)");
                        Optional<String> foundPath = foundEntries.stream().filter(path -> p.matcher((CharSequence)path).matches()).findFirst();
                        if (foundPath.isPresent()) {
                            mvnExecPath = foundPath.get();
                            LOG.debug("Taking {} instead of first entry as detected windows OS", (Object)mvnExecPath);
                        }
                    }
                    if (mvnExecPath == null) {
                        mvnExecPath = (String)foundEntries.get(0);
                    }
                }
                if ((retVal = process.waitFor()) == 0 && StringUtils.isNotEmpty(mvnExecPath)) {
                    LOG.info("Determined mvn executable to be located in {}", (Object)mvnExecPath);
                    MVN_EXEC = Paths.get(mvnExecPath, new String[0]);
                } else {
                    LOG.warn("Could not determine mvn executable location. 'which mvn' returned {}", (Object)retVal);
                }
            }
        }
        catch (IOException | InterruptedException e2) {
            LOG.warn("Could not determine mvn executable location, trying to look for environment variables for maven home.", (Throwable)e2);
        }
        if (MVN_EXEC == null) {
            String m2Home = System.getenv().get("MAVEN_HOME");
            if (m2Home == null && (m2Home = System.getenv().get("M2_HOME")) == null) {
                if ("true".equals(System.getenv("TRAVIS"))) {
                    m2Home = "/usr/local/maven";
                } else {
                    throw new CobiGenRuntimeException("Could not determine maven home from environment variables MAVEN_HOME or M2_HOME!");
                }
            }
            MVN_EXEC = SystemUtil.getMvnExecutable(m2Home);
            LOG.info("Determined maven executable at {}", (Object)MVN_EXEC);
        } else {
            LOG.debug("Detected to run on OS {}", (Object)OS);
            MVN_EXEC = SystemUtil.convertUnixPathToWinOnWin(mvnExecPath);
        }
        return MVN_EXEC;
    }

    public static Path convertUnixPathToWinOnWin(String path) {
        Path returnVal = Paths.get(path, new String[0]);
        if (OS.contains("win")) {
            Pattern p = Pattern.compile("/([a-zA-Z])/(.+)");
            Matcher matcher = p.matcher(path);
            if (matcher.matches()) {
                LOG.debug("unix path {} matches with group1='{}' and group2='{}'", new Object[]{path, matcher.group(1), matcher.group(2)});
                returnVal = Paths.get(matcher.group(1) + ":\\" + matcher.group(2).replace("/", "\\"), new String[0]);
                LOG.debug("Reformatted unix path to '{}' as running on windows within a shell or bash", (Object)returnVal);
            } else {
                LOG.debug("unix path {} does not match", (Object)path);
            }
        }
        return returnVal;
    }

    public static String getOS() {
        return OS;
    }

    private static Path getMvnExecutable(String mvnHome) {
        return Paths.get(mvnHome, new String[0]).resolve("bin/mvn" + (OS.contains("win") ? ".cmd" : ""));
    }
}

