/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.util;

import com.devonfw.cobigen.api.constants.MavenConstants;
import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import com.devonfw.cobigen.api.util.SystemUtil;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class MavenUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MavenUtil.class);

    public static void cacheMavenClassPath(Path pomFile, Path cpFile) {
        MavenUtil.cleanupExistingClassPathCaches(cpFile);
        LOG.info("Calculating class path for {} and downloading the needed maven dependencies. Please be patient...", (Object)pomFile);
        ArrayList args = Lists.newArrayList((Object[])new String[]{SystemUtil.determineMvnPath().toString(), "dependency:build-classpath", "-Dmdep.outputFile=" + cpFile.toString()});
        if (pomFile.getFileSystem().provider().getClass().getSimpleName().equals("ZipFileSystemProvider")) {
            pomFile = MavenUtil.createCachedPomFromJar(pomFile, cpFile.getParent());
            args.add("-f");
            args.add(pomFile.toString());
        }
        MavenUtil.runCommand(pomFile.getParent(), args);
        LOG.debug("Downloaded dependencies successfully.");
    }

    public static void resolveDependencies(Path mvnProjectRoot) {
        LOG.info("Resolving maven dependencies for maven project {} to be able to make use of reflection in templates. Please be patient...", (Object)mvnProjectRoot);
        ArrayList args = Lists.newArrayList((Object[])new String[]{SystemUtil.determineMvnPath().toString(), "dependency:resolve"});
        MavenUtil.runCommand(mvnProjectRoot, args);
        LOG.debug("Downloaded dependencies successfully.");
    }

    public static void resolveDependencies(Path pomFile, Path mvnProjectRoot) {
        LOG.info("Resolving maven dependencies for maven project {} to be able to make use of reflection in templates. Please be patient...", (Object)mvnProjectRoot);
        if (pomFile.getFileSystem().provider().getClass().getSimpleName().equals("ZipFileSystemProvider")) {
            pomFile = MavenUtil.createCachedPomFromJar(pomFile, mvnProjectRoot);
        }
        ArrayList args = Lists.newArrayList((Object[])new String[]{SystemUtil.determineMvnPath().toString()});
        args.add("-f");
        args.add(pomFile.toString());
        args.add("dependency:resolve");
        MavenUtil.runCommand(mvnProjectRoot, args);
        LOG.debug("Downloaded dependencies successfully.");
    }

    public static Path createCachedPomFromJar(Path pomFile, Path outputPath) {
        Path cachedPomXml = outputPath.resolve("cached-pom.xml");
        try {
            Files.copy(pomFile, cachedPomXml, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new CobiGenRuntimeException("Unable to extract " + pomFile.toUri() + " from JAR to " + cachedPomXml, e);
        }
        pomFile = cachedPomXml;
        cachedPomXml.toFile().deleteOnExit();
        return cachedPomXml;
    }

    public static URLClassLoader addURLsFromCachedClassPathsFile(Path classPathCacheFile, Path pomFile, ClassLoader parentClassLoader) {
        URLClassLoader uRLClassLoader;
        block10: {
            if (!Files.exists(classPathCacheFile, new LinkOption[0])) {
                LOG.debug("Building class paths for maven configuration ...");
                MavenUtil.cacheMavenClassPath(pomFile, classPathCacheFile);
            } else {
                LOG.debug("Taking cached class paths from: {}", (Object)classPathCacheFile);
            }
            Stream<String> fileLinesStream = Files.lines(classPathCacheFile);
            try {
                URL[] classPathEntries = (URL[])fileLinesStream.flatMap(e -> Arrays.stream(e.split(SystemUtil.getOS().contains("win") ? ";" : ":"))).map(path -> {
                    try {
                        return new File((String)path).toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        LOG.error("URL of class path entry {} is malformed", path, (Object)e);
                        return null;
                    }
                }).toArray(URL[]::new);
                uRLClassLoader = new URLClassLoader(classPathEntries, parentClassLoader);
                if (fileLinesStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fileLinesStream != null) {
                        try {
                            fileLinesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new CobiGenRuntimeException("Unable to read " + classPathCacheFile, e2);
                }
            }
            fileLinesStream.close();
        }
        return uRLClassLoader;
    }

    public static String generatePomFileHash(Path pomFile) {
        String pomFileHash;
        try {
            pomFileHash = ByteSource.wrap((byte[])Files.readAllBytes(pomFile)).hash(Hashing.murmur3_128()).toString();
        }
        catch (IOException e) {
            LOG.warn("Could not calculate hash of {}", (Object)pomFile.toUri());
            pomFileHash = "";
        }
        return pomFileHash;
    }

    public static Path determineMavenRepositoryPath() {
        LOG.info("Determine maven repository path");
        String m2Repo = MavenUtil.runCommand(SystemUtils.getUserHome().toPath(), Lists.newArrayList((Object[])new String[]{SystemUtil.determineMvnPath().toString(), "help:evaluate", "-Dexpression=settings.localRepository", "-DforceStdout"}));
        LOG.debug("Determined {} as maven repository path.", (Object)m2Repo);
        return Paths.get(m2Repo, new String[0]);
    }

    private static String runCommand(Path execDir, List<String> args) {
        args.add("-Djansi.force=true");
        args.add("-Djansi.passthrough=true");
        args.add("-B");
        args.add("-q");
        args.add("-Dorg.slf4j.simpleLogger.defaultLogLevel=" + (LOG.isDebugEnabled() ? "DEBUG" : "INFO"));
        args.add("-Dorg.slf4j.simpleLogger.log.org.apache.maven.cli.transfer.Slf4jMavenTransferListener=WARN");
        try {
            StartedProcess process = new ProcessExecutor().readOutput(true).destroyOnExit().directory(execDir.toFile()).environment("MAVEN_OPTS", MavenUtil.replaceAllUnixPathsOnWin(System.getenv("MAVEN_OPTS"))).environment("M2_REPO", MavenUtil.replaceAllUnixPathsOnWin(System.getenv("M2_REPO"))).command(args).redirectError((OutputStream)Slf4jStream.of((Logger)LoggerFactory.getLogger((String)(MavenUtil.class.getName() + ".dep-build"))).asError()).redirectOutput((OutputStream)Slf4jStream.of((Logger)LoggerFactory.getLogger((String)(MavenUtil.class.getName() + ".dep-build"))).asInfo()).start();
            Future future = process.getFuture();
            ProcessResult processResult = (ProcessResult)future.get();
            if (processResult.getExitValue() != 0) {
                LOG.error("Error while getting all the needed transitive dependencies. Please check your internet connection.");
                throw new CobiGenRuntimeException("Unable to build cobigen dependencies");
            }
            return processResult.getOutput().getString("UTF-8");
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new CobiGenRuntimeException("Unable to build cobigen dependencies", e);
        }
    }

    private static String replaceAllUnixPathsOnWin(String string) {
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            Pattern p = Pattern.compile("=((/[^/]+)+/?)");
            Matcher matcher = p.matcher(string);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, "=" + SystemUtil.convertUnixPathToWinOnWin(matcher.group(1)).toString().replace("\\", "\\\\"));
            }
            matcher.appendTail(sb);
            string = sb.toString();
        }
        return string;
    }

    private static void cleanupExistingClassPathCaches(Path cpFile) {
        Path rootPath = cpFile.getParent();
        try {
            Files.walk(rootPath, new FileVisitOption[0]).filter(p -> p.getFileName().startsWith(MavenConstants.CLASSPATH_CACHE_FILE.replace("%s.txt", ""))).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    LOG.warn("Failed cleaning up old classpath cache file {}", p);
                }
            });
        }
        catch (IOException e) {
            LOG.warn("Failed cleaning up old classpath cache files in {}", (Object)rootPath);
        }
    }

    private static Path findPom(Path source, boolean foundPom, boolean topLevel) {
        if (source == null) {
            return null;
        }
        if (Files.isRegularFile(source, new LinkOption[0])) {
            if (source.getFileName().toString().equals(MavenConstants.POM) && Files.exists(source, new LinkOption[0])) {
                LOG.info("{} is already a pom.xml.");
                return source;
            }
            LOG.warn("File {} neither exists nor is a {}, trying to search for {} in one of the parent folders.", new Object[]{source, MavenConstants.POM, MavenConstants.POM});
            return MavenUtil.findPom(source.getParent(), foundPom, topLevel);
        }
        Path pomFile = source.resolve(MavenConstants.POM);
        if (Files.exists(pomFile, new LinkOption[0]) && Files.isRegularFile(pomFile, new LinkOption[0]) && (!topLevel || MavenUtil.findPom(source.getParent(), false, topLevel) == null)) {
            LOG.debug("Stop searching pom as no pom.xml in parent directory. Taking {} as top-level pom.xml", (Object)pomFile);
            return pomFile;
        }
        if (foundPom) {
            return null;
        }
        return MavenUtil.findPom(source.getParent(), foundPom, topLevel);
    }

    public static Path getProjectRoot(Path inputFile, boolean topLevel) {
        Path pomFile = MavenUtil.findPom(inputFile, false, topLevel);
        if (pomFile != null) {
            LOG.info("Found project root in path {}", (Object)pomFile.getParent());
            return pomFile.getParent();
        }
        LOG.debug("Project root could not be found.");
        return null;
    }
}

