/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.util;

import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ExceptionUtil {
    public static <T extends Throwable> T getCause(Throwable e, Class<T> cause) {
        Throwable curr;
        for (curr = e; curr != null && !cause.isAssignableFrom(curr.getClass()); curr = curr.getCause()) {
        }
        if (curr != null) {
            return (T)curr;
        }
        return null;
    }

    public static Throwable getCause(Throwable e, Class<?> ... causes) {
        for (Class<?> cause : causes) {
            Throwable curr;
            for (curr = e; curr != null && !cause.isAssignableFrom(curr.getClass()); curr = curr.getCause()) {
            }
            if (curr == null) continue;
            return curr;
        }
        return null;
    }

    public static Object invokeTarget(Object targetObject, Method method, Object[] args) {
        try {
            return method.invoke(targetObject, args);
        }
        catch (IllegalAccessException e) {
            throw new CobiGenRuntimeException("Could not access method " + method.toGenericString() + ". This is a bug!", e);
        }
        catch (InvocationTargetException e) {
            CobiGenRuntimeException cause = ExceptionUtil.getCause((Throwable)e, CobiGenRuntimeException.class);
            if (cause != null) {
                throw cause;
            }
            throw new CobiGenRuntimeException("Unable to invoke " + method.toGenericString() + ".", e);
        }
    }
}

