/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.property.PropertyResolver;

public class IntrospectorPropertyResolver
extends PropertyResolver {
    private boolean includeTransientFields;

    public IntrospectorPropertyResolver(boolean includePublicFields) {
        this(includePublicFields, true);
    }

    public IntrospectorPropertyResolver(boolean includePublicFields, boolean includeTransientFields) {
        super(includePublicFields);
        this.includeTransientFields = includeTransientFields;
    }

    public IntrospectorPropertyResolver() {
        super(true);
    }

    @Override
    protected void collectProperties(Class<?> type, Type<?> referenceType, Map<String, Property> properties) {
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            for (PropertyDescriptor pd : descriptors = beanInfo.getPropertyDescriptors()) {
                try {
                    Method readMethod = this.getReadMethod(pd, type);
                    if (!this.includeTransientFields && this.isTransient(readMethod)) continue;
                    Method writeMethod = this.getWriteMethod(pd, type, null);
                    Property property = this.processProperty(pd.getName(), pd.getPropertyType(), readMethod, writeMethod, type, referenceType, properties);
                    this.postProcessProperty(property, pd, readMethod, writeMethod, type, referenceType, properties);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error while trying to resolve property " + referenceType.getCanonicalName() + ", [" + pd.getName() + "]", e);
                }
            }
        }
        catch (IntrospectionException e) {
            throw new MappingException(e);
        }
    }

    private boolean isTransient(Method readMethod) {
        if (readMethod != null) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = readMethod.getAnnotations()) {
                if (!annotation.annotationType().getName().equals("java.beans.Transient")) continue;
                return true;
            }
        }
        return false;
    }

    private void postProcessProperty(Property property, PropertyDescriptor pd, Method readMethod, Method writeMethod, Class<?> type, Type<?> referenceType, Map<String, Property> properties) {
        if (writeMethod == null && property != null && (writeMethod = this.getWriteMethod(pd, type, property.getRawType())) != null) {
            this.processProperty(property.getName(), property.getRawType(), readMethod, writeMethod, type, referenceType, properties);
        }
    }

    private Method getReadMethod(PropertyDescriptor pd, Class<?> type) {
        String capitalName = this.capitalize(pd.getName());
        Method readMethod = pd.getReadMethod();
        if (readMethod == null) {
            try {
                readMethod = type.getMethod("get" + capitalName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                readMethod = null;
            }
        }
        if (readMethod == null && Boolean.class.equals(pd.getPropertyType())) {
            try {
                readMethod = type.getMethod("is" + capitalName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                readMethod = null;
            }
        }
        if (readMethod != null && readMethod.isBridge()) {
            readMethod = IntrospectorPropertyResolver.getNonBridgeAccessor(readMethod);
        }
        return readMethod;
    }

    private Method getWriteMethod(PropertyDescriptor pd, Class<?> type, Class<?> propertyType) {
        String capitalName = this.capitalize(pd.getName());
        Class<?> parameterType = propertyType != null ? propertyType : pd.getPropertyType();
        Method writeMethod = pd.getWriteMethod();
        if (!(writeMethod != null || "Class".equals(capitalName) && Class.class.equals(parameterType))) {
            try {
                writeMethod = type.getMethod("set" + capitalName, parameterType);
            }
            catch (NoSuchMethodException e) {
                writeMethod = null;
            }
        }
        if (writeMethod == null) {
            try {
                writeMethod = type.getMethod("set" + capitalName, parameterType);
            }
            catch (NoSuchMethodException e) {
                writeMethod = null;
            }
        }
        return writeMethod;
    }

    private static Method getNonBridgeAccessor(Method bridgeMethod) {
        Method[] otherMethods;
        Method realMethod = bridgeMethod;
        for (Method possibleRealMethod : otherMethods = bridgeMethod.getDeclaringClass().getMethods()) {
            if (!possibleRealMethod.getName().equals(bridgeMethod.getName()) || possibleRealMethod.isBridge() || possibleRealMethod.getParameterTypes().length != 0) continue;
            realMethod = possibleRealMethod;
            break;
        }
        return realMethod;
    }
}

