/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.lang.reflect.Type;

public class ConverterKey {
    private final Type sourceType;
    private final Type destinationType;
    private final String id;

    public ConverterKey(Type sourceType, Type destinationType) {
        assert (sourceType != null);
        assert (destinationType != null);
        this.sourceType = sourceType;
        this.destinationType = destinationType;
        this.id = null;
    }

    public ConverterKey(String id) {
        assert (id != null);
        this.id = id;
        this.sourceType = null;
        this.destinationType = null;
    }

    public Type getSourceClass() {
        return this.sourceType;
    }

    public Type getDestinationClass() {
        return this.destinationType;
    }

    public String toString() {
        return "[" + this.sourceType + ", " + this.destinationType + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.id == null) {
            result = 31 * result + this.destinationType.hashCode();
            result = 31 * result + this.sourceType.hashCode();
        } else {
            result = 31 * result + this.id.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConverterKey other = (ConverterKey)obj;
        if (this.id != null) {
            return this.id.equals(other.id);
        }
        return this.destinationType.equals(other.destinationType) && this.sourceType.equals(other.sourceType);
    }
}

