/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.math.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.mmm.util.math.api.NumberConversionException;
import net.sf.mmm.util.math.api.NumberType;

public abstract class NumberTypeImpl<NUMBER extends Number>
implements NumberType<NUMBER> {
    private static final double REQUIRED_PRECISION = 1.0E-7;
    public static final NumberTypeImpl<Byte> BYTE = new NumberTypeImpl<Byte>(1, Byte.valueOf((byte)-128), Byte.valueOf((byte)127)){

        @Override
        public Class<Byte> getNumberClass() {
            return Byte.class;
        }

        @Override
        public boolean isDecimal() {
            return false;
        }

        @Override
        protected Byte convert(Number number) {
            return number.byteValue();
        }

        @Override
        protected Byte parse(String number) throws NumberFormatException {
            return Byte.valueOf(number);
        }
    };
    public static final NumberTypeImpl<Short> SHORT = new NumberTypeImpl<Short>(2, Short.valueOf((short)Short.MIN_VALUE), Short.valueOf((short)Short.MAX_VALUE)){

        @Override
        public Class<Short> getNumberClass() {
            return Short.class;
        }

        @Override
        public boolean isDecimal() {
            return false;
        }

        @Override
        protected Short convert(Number number) {
            return number.shortValue();
        }

        @Override
        protected Short parse(String number) throws NumberFormatException {
            return Short.valueOf(number);
        }
    };
    public static final NumberTypeImpl<Integer> INTEGER = new NumberTypeImpl<Integer>(3, Integer.valueOf(Integer.MIN_VALUE), Integer.valueOf(Integer.MAX_VALUE)){

        @Override
        public Class<Integer> getNumberClass() {
            return Integer.class;
        }

        @Override
        public boolean isDecimal() {
            return false;
        }

        @Override
        protected Integer convert(Number number) {
            return number.intValue();
        }

        @Override
        protected Integer parse(String number) throws NumberFormatException {
            return Integer.valueOf(number);
        }
    };
    public static final NumberTypeImpl<Long> LONG = new NumberTypeImpl<Long>(4, Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE)){

        @Override
        public Class<Long> getNumberClass() {
            return Long.class;
        }

        @Override
        public boolean isDecimal() {
            return false;
        }

        @Override
        protected Long convert(Number number) {
            return number.longValue();
        }

        @Override
        protected Long parse(String number) throws NumberFormatException {
            return Long.valueOf(number);
        }
    };
    public static final NumberTypeImpl<Float> FLOAT = new NumberTypeImpl<Float>(5, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE)){

        @Override
        public Class<Float> getNumberClass() {
            return Float.class;
        }

        @Override
        public boolean isDecimal() {
            return true;
        }

        @Override
        protected Float convert(Number number) {
            return Float.valueOf(number.floatValue());
        }

        @Override
        protected Float parse(String number) throws NumberFormatException {
            return Float.valueOf(number);
        }
    };
    public static final NumberTypeImpl<Double> DOUBLE = new NumberTypeImpl<Double>(6, Double.valueOf(Double.MIN_VALUE), Double.valueOf(Double.MAX_VALUE)){

        @Override
        public Class<Double> getNumberClass() {
            return Double.class;
        }

        @Override
        public boolean isDecimal() {
            return true;
        }

        @Override
        protected Double convert(Number number) {
            return number.doubleValue();
        }

        @Override
        protected Double parse(String number) throws NumberFormatException {
            return Double.valueOf(number);
        }
    };
    public static final NumberTypeImpl<BigInteger> BIG_INTEGER = new NumberTypeImpl<BigInteger>(7, null, null){

        @Override
        public Class<BigInteger> getNumberClass() {
            return BigInteger.class;
        }

        @Override
        public boolean isDecimal() {
            return false;
        }

        @Override
        protected BigInteger convert(Number number) {
            return BigInteger.valueOf(number.longValue());
        }

        @Override
        protected BigInteger parse(String number) throws NumberFormatException {
            return new BigInteger(number);
        }
    };
    public static final NumberTypeImpl<BigDecimal> BIG_DECIMAL = new NumberTypeImpl<BigDecimal>(8, null, null){

        @Override
        public Class<BigDecimal> getNumberClass() {
            return BigDecimal.class;
        }

        @Override
        public boolean isDecimal() {
            return true;
        }

        @Override
        protected BigDecimal convert(Number number) {
            return BigDecimal.valueOf(number.doubleValue());
        }

        @Override
        protected BigDecimal parse(String number) throws NumberFormatException {
            return new BigDecimal(number);
        }
    };
    private final int exactness;
    private final NUMBER minimumValue;
    private final NUMBER maximumValue;

    NumberTypeImpl(int exactness, NUMBER min, NUMBER max) {
        this.exactness = exactness;
        this.minimumValue = min;
        this.maximumValue = max;
    }

    protected abstract NUMBER convert(Number var1);

    @Override
    public NUMBER valueOf(Number number, boolean failIfUnprecise) throws NumberConversionException {
        if (number == null) {
            return null;
        }
        if (this.getNumberClass().equals(number.getClass())) {
            return (NUMBER)number;
        }
        NUMBER converted = this.convert(number);
        if (failIfUnprecise) {
            double delta = number.doubleValue() - ((Number)converted).doubleValue();
            if (delta == 0.0) {
                delta = number.longValue() - ((Number)converted).longValue();
            }
            if (delta < 0.0) {
                delta = -delta;
            }
            if (delta > 1.0E-7) {
                throw new NumberConversionException(number, this.getNumberClass());
            }
        }
        return converted;
    }

    @Override
    public NUMBER valueOf(String number) throws NumberConversionException {
        try {
            return this.parse(number);
        }
        catch (NumberFormatException e) {
            throw new NumberConversionException(e, number, this.getNumberClass());
        }
    }

    protected abstract NUMBER parse(String var1) throws NumberConversionException, NumberFormatException;

    @Override
    public int getExactnessDifference(NumberType<?> otherType) {
        return this.exactness - ((NumberTypeImpl)otherType).exactness;
    }

    @Override
    public NUMBER getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public NUMBER getMaximumValue() {
        return this.maximumValue;
    }
}

