/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.descriptor;

import java.time.LocalDate;
import net.sf.mmm.util.lang.base.datatype.descriptor.AbstractDatatypeDescriptor;
import net.sf.mmm.util.lang.base.datatype.descriptor.AbstractDatatypeSegmentDescriptor;

public class DatatypeDescriptorLocalDate
extends AbstractDatatypeDescriptor<LocalDate> {
    public DatatypeDescriptorLocalDate() {
        super(LocalDate.class, new YearSegment(), new MonthSegment(), new DaySegment());
    }

    @Override
    protected LocalDate doCreate(Object ... segments) {
        int year = (Integer)segments[0];
        int month = (Integer)segments[1];
        int day = (Integer)segments[2];
        return LocalDate.of(year, month, day);
    }

    private static class DaySegment
    extends AbstractDatatypeSegmentDescriptor<LocalDate, Integer> {
        public DaySegment() {
            super("day", Integer.class);
        }

        @Override
        protected Integer doGetSegment(LocalDate datatype) {
            return datatype.getDayOfMonth();
        }
    }

    private static class MonthSegment
    extends AbstractDatatypeSegmentDescriptor<LocalDate, Integer> {
        public MonthSegment() {
            super("month", Integer.class);
        }

        @Override
        protected Integer doGetSegment(LocalDate datatype) {
            return datatype.getMonthValue();
        }
    }

    private static class YearSegment
    extends AbstractDatatypeSegmentDescriptor<LocalDate, Integer> {
        public YearSegment() {
            super("year", Integer.class);
        }

        @Override
        protected Integer doGetSegment(LocalDate datatype) {
            return datatype.getYear();
        }
    }
}

