/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.api;

import net.sf.mmm.util.reflect.api.ReflectionUtilLimited;

public class Arguments {
    public static final Arguments NO_ARGS = new Arguments(ReflectionUtilLimited.NO_ARGUMENTS);
    private final Object[] args;
    private final int hash;

    public Arguments(Object ... arguments) {
        this.args = arguments;
        int hashcode = 0;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            hashcode = 31 * hashcode + this.args[i].hashCode();
        }
        hashcode <<= 2;
        this.hash = hashcode |= this.args.length;
    }

    public int getArgumentCount() {
        return this.args.length;
    }

    public Object getArgument(int position) {
        return this.args[position];
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Arguments other = (Arguments)obj;
            if (this.args.length == other.args.length) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i] == other.args[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('[');
        if (this.args.length > 0) {
            result.append('<');
            result.append(this.args[0]);
            for (int i = 1; i < this.args.length; ++i) {
                result.append(">,<");
                result.append(this.args[i]);
            }
            result.append('>');
        }
        result.append(']');
        return result.toString();
    }
}

