/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl.formatter;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.lang.api.Visitor;
import net.sf.mmm.util.nls.api.NlsArgument;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;
import net.sf.mmm.util.nls.base.AbstractNlsMessageFormatter;
import net.sf.mmm.util.nls.base.NlsDependencies;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;

public class NlsMessageFormatterImpl
extends AbstractNlsMessageFormatter {
    private final PatternSegment[] segments;
    private final String suffix;
    private final NlsDependencies nlsDependnecies;

    public NlsMessageFormatterImpl(String pattern, NlsDependencies nlsDependencies) {
        NlsNullPointerException.checkNotNull(NlsDependencies.class, nlsDependencies);
        this.nlsDependnecies = nlsDependencies;
        ArrayList<PatternSegment> segmentList = new ArrayList<PatternSegment>();
        CharSequenceScanner scanner = new CharSequenceScanner(pattern);
        String prefix = scanner.readUntil('{', true, '\\');
        while (scanner.hasNext()) {
            NlsArgument argument;
            int index = scanner.getCurrentIndex() - 1;
            try {
                argument = this.nlsDependnecies.getArgumentParser().parse(scanner);
            }
            catch (Exception e) {
                throw new NlsParseException((Throwable)e, (Object)scanner.substring(index, scanner.getCurrentIndex()), (Type)((Object)NlsArgument.class));
            }
            PatternSegment segment = new PatternSegment(prefix, argument);
            segmentList.add(segment);
            prefix = scanner.readUntil('{', true, '\\');
        }
        this.suffix = prefix;
        this.segments = segmentList.toArray(new PatternSegment[segmentList.size()]);
    }

    @Override
    public final void format(Void nothing, Locale locale, Map<String, Object> arguments, NlsTemplateResolver resolver, Appendable buffer) throws IOException {
        for (PatternSegment segment : this.segments) {
            buffer.append(segment.prefix);
            NlsArgument argument = segment.argument;
            this.nlsDependnecies.getArgumentFormatter().format(argument, locale, arguments, resolver, buffer);
        }
        buffer.append(this.suffix);
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void visit(Visitor<String> staticTextVisitor, Visitor<NlsArgument> dynamicArgumentVisitor) {
        for (PatternSegment segment : this.segments) {
            staticTextVisitor.visit(segment.prefix);
            dynamicArgumentVisitor.visit(segment.argument);
        }
        staticTextVisitor.visit(this.suffix);
    }

    protected static class PatternSegment {
        private final String prefix;
        private final NlsArgument argument;

        public PatternSegment(String prefix, NlsArgument argument) {
            this.prefix = prefix;
            this.argument = argument;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public NlsArgument getArgument() {
            return this.argument;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.prefix);
            sb.append(this.argument);
            return sb.toString();
        }
    }
}

