/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import net.sf.mmm.util.lang.base.CoreCharSequence;

public class CharSubSequence
extends CoreCharSequence {
    private final CharSequence original;
    private final int start;
    private final int length;

    public CharSubSequence(CharSequence originalSequence, int startPosition, int endPosition) {
        this.original = originalSequence;
        this.start = startPosition;
        this.length = endPosition - startPosition;
    }

    @Override
    public CharSequence subSequence(int startPosition, int endPosition) {
        if (startPosition < 0) {
            throw new IndexOutOfBoundsException("Start (" + startPosition + ") must not be negative!");
        }
        if (endPosition < startPosition) {
            throw new IndexOutOfBoundsException("End (" + endPosition + ") must be greater or equal to start (" + startPosition + ")!");
        }
        if (endPosition > this.length()) {
            throw new IndexOutOfBoundsException("End (" + endPosition + ") greater than length of sequence (" + this.length() + ")");
        }
        return new CharSubSequence(this.original, this.start + startPosition, endPosition);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.original.charAt(index + this.start);
    }
}

