/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.collection.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.mmm.util.value.api.SimpleValueConverter;

public class NodeCycle<V> {
    private List<V> inverseCycle;
    private V startNode;
    private final SimpleValueConverter<V, String> formatter;

    public NodeCycle(V startNode) {
        this(startNode, null);
    }

    public NodeCycle(V startNode, SimpleValueConverter<V, String> formatter) {
        this.startNode = startNode;
        this.formatter = formatter;
        this.inverseCycle = new ArrayList<V>();
        this.inverseCycle.add(this.startNode);
    }

    public List<V> getInverseCycle() {
        return this.inverseCycle;
    }

    public V getStartNode() {
        return this.startNode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.inverseCycle.size() - 1; i >= 0; --i) {
            V node = this.inverseCycle.get(i);
            if (this.formatter == null) {
                sb.append(node);
            } else {
                sb.append(this.formatter.convert(node, NodeCycle.class, String.class));
            }
            if (i <= 0) continue;
            sb.append("-->");
        }
        return sb.toString();
    }
}

