/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ma.glasnost.orika.util.Node;
import ma.glasnost.orika.util.Ordering;
import ma.glasnost.orika.util.TopologicalSorter;

public class SortedCollection<V>
implements Collection<V> {
    protected final Ordering<V> ordering;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock sortLock = new ReentrantReadWriteLock();
    private Set<Node<V>> nodes = new LinkedHashSet<Node<V>>();
    private List<V> items = new ArrayList<V>();
    private volatile List<V> sortedItems = null;

    public SortedCollection(Ordering<V> ordering) {
        this.ordering = ordering;
    }

    public SortedCollection(Collection<? extends V> c, Ordering<V> ordering) {
        this(ordering);
        this.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(V value) {
        try {
            this.rwl.writeLock().lock();
            if (this.mustAdd(value)) {
                this.items.add(value);
                Node<V> newNode = new Node<V>(value);
                for (Node<V> from : this.nodes) {
                    Ordering.OrderingRelation order = this.ordering.order(from.getValue(), newNode.getValue());
                    if (order == Ordering.OrderingRelation.AFTER) {
                        from.addEdge(newNode);
                        continue;
                    }
                    if (order != Ordering.OrderingRelation.BEFORE) continue;
                    newNode.addEdge(from);
                }
                this.nodes.add(newNode);
                this.sortedItems = null;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    protected boolean mustAdd(V item) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        boolean result = false;
        if (this.contains(o)) {
            try {
                this.rwl.writeLock().lock();
                List<V> sorted = this.getSortedItems();
                this.nodes.clear();
                this.items.clear();
                this.sortedItems = null;
                result = sorted.remove(o);
                this.addAll((Collection<? extends V>)sorted);
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
        return result;
    }

    @Override
    public void clear() {
        try {
            this.rwl.writeLock().lock();
            this.nodes.clear();
            this.items.clear();
            this.sortedItems = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private List<V> getSortedItems() {
        if (this.sortedItems == null) {
            try {
                this.sortLock.writeLock().lock();
                if (this.sortedItems == null) {
                    this.sortedItems = TopologicalSorter.sort(this.nodes);
                }
            }
            finally {
                this.sortLock.writeLock().unlock();
            }
        }
        return this.sortedItems;
    }

    @Override
    public int size() {
        try {
            this.rwl.readLock().lock();
            int n = this.items.size();
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.rwl.readLock().lock();
            boolean bl = this.items.isEmpty();
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public Iterator<V> iterator() {
        try {
            this.rwl.readLock().lock();
            Iterator<V> iterator = this.getSortedItems().iterator();
            return iterator;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        try {
            this.rwl.readLock().lock();
            boolean bl = this.items.contains(o);
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        try {
            this.rwl.readLock().lock();
            Object[] objectArray = this.getSortedItems().toArray();
            return objectArray;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        try {
            this.rwl.readLock().lock();
            T[] TArray = this.getSortedItems().toArray(a);
            return TArray;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        try {
            this.rwl.readLock().lock();
            boolean bl = this.items.containsAll(c);
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends V> c) {
        try {
            this.rwl.writeLock().lock();
            boolean ret = false;
            for (V curItem : c) {
                ret |= this.add(curItem);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        try {
            this.rwl.writeLock().lock();
            boolean ret = false;
            for (Object curItem : c) {
                ret |= this.remove(curItem);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public V first() {
        try {
            this.rwl.readLock().lock();
            V v = this.items.isEmpty() ? null : (V)this.getSortedItems().get(0);
            return v;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }
}

