/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.converter.builtin.BuiltinCustomConverter;
import ma.glasnost.orika.metadata.Type;

public class FromStringConverter
extends BuiltinCustomConverter<Object, Object> {
    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        return String.class == sourceType.getRawType() && destinationType.isConvertibleFromString();
    }

    @Override
    public Object convert(Object source, Type<? extends Object> destinationType, MappingContext context) {
        if (destinationType.isEnum()) {
            return this.convertToEnum((String)source, destinationType);
        }
        if (destinationType.isPrimitive()) {
            return this.convertToPrimitive((String)source, destinationType);
        }
        return this.convertToWrapper((String)source, destinationType);
    }

    private Object convertToEnum(String source, Type<? extends Object> destinationType) {
        return Enum.valueOf(destinationType.getRawType(), source.toString());
    }

    private Object convertToPrimitive(String source, Type<? extends Object> destinationType) {
        if (Character.TYPE == destinationType.getRawType()) {
            return Character.valueOf(source.charAt(0));
        }
        if (Byte.TYPE == destinationType.getRawType()) {
            return Byte.parseByte(source);
        }
        if (Short.TYPE == destinationType.getRawType()) {
            return Short.parseShort(source);
        }
        if (Integer.TYPE == destinationType.getRawType()) {
            return Integer.parseInt(source);
        }
        if (Long.TYPE == destinationType.getRawType()) {
            return Long.parseLong(source);
        }
        if (Float.TYPE == destinationType.getRawType()) {
            return Float.valueOf(Float.parseFloat(source));
        }
        if (Double.TYPE == destinationType.getRawType()) {
            return Double.parseDouble(source);
        }
        if (Boolean.TYPE == destinationType.getRawType()) {
            return Boolean.parseBoolean(source);
        }
        return null;
    }

    private Object convertToWrapper(String source, Type<? extends Object> destinationType) {
        if (Character.class == destinationType.getRawType()) {
            return Character.valueOf(source.charAt(0));
        }
        if (Byte.class == destinationType.getRawType()) {
            return Byte.valueOf(source);
        }
        if (Short.class == destinationType.getRawType()) {
            return Short.valueOf(source);
        }
        if (Integer.class == destinationType.getRawType()) {
            return Integer.valueOf(source);
        }
        if (Long.class == destinationType.getRawType()) {
            return Long.valueOf(source);
        }
        if (Float.class == destinationType.getRawType()) {
            return Float.valueOf(source);
        }
        if (Double.class == destinationType.getRawType()) {
            return Double.valueOf(source);
        }
        if (Boolean.class == destinationType.getRawType()) {
            return Boolean.valueOf(source);
        }
        return null;
    }
}

