/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.cli.utils;

import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import com.devonfw.cobigen.api.to.GenerationReportTo;
import com.devonfw.cobigen.cli.CobiGenCLI;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.InputMismatchException;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationUtils {
    private static Logger LOG = LoggerFactory.getLogger(CobiGenCLI.class);
    private static final Scanner inputReader = new Scanner(System.in);

    public boolean validateFile(File inputFile) {
        if (inputFile == null) {
            return false;
        }
        if (!inputFile.exists()) {
            LOG.error("The input file " + inputFile.getAbsolutePath() + " has not been found on your system.");
            return false;
        }
        if (!inputFile.canRead()) {
            LOG.error("The input file '{}' cannot be read. Please check file permissions on the file", (Object)inputFile.getAbsolutePath());
            return false;
        }
        return true;
    }

    public static boolean isOutputRootPathValid(Path outputRootPath) {
        if (outputRootPath == null || Files.exists(outputRootPath, new LinkOption[0])) {
            return true;
        }
        LOG.error("Your <outputRootPath> '{}' does not exist, please use a valid path.", (Object)outputRootPath);
        return false;
    }

    public static void checkGenerationReport(GenerationReportTo report) {
        for (String warning : report.getWarnings()) {
            LOG.debug("Warning: {}", (Object)warning);
        }
        if (report.getErrors() != null && !report.getErrors().isEmpty()) {
            if (LOG.isDebugEnabled() && report.getErrors().size() > 1) {
                for (int i = 1; i < report.getErrors().size(); ++i) {
                    LOG.error("Further reported error:", (Throwable)report.getErrors().get(i));
                }
            }
            if (report.getErrors().get(0) instanceof CobiGenRuntimeException) {
                throw (RuntimeException)report.getErrors().get(0);
            }
            throw new CobiGenRuntimeException("Generation failed. Enable debug mode to see the exceptions occurred.", (Throwable)report.getErrors().get(0));
        }
        LOG.info("Successful generation.");
    }

    public static void throwNoTriggersMatched(Path inputFile, boolean isJavaInput, boolean isOpenApiInput) {
        LOG.error("Your input file '{}' is not valid as input for any generation purpose. It does not match any trigger.", (Object)inputFile.getFileName());
        if (isJavaInput) {
            LOG.error("Check that your Java input file is following devon4j naming convention. Explained on https://devonfw.com/website/pages/docs/devon4j.asciidoc_coding-conventions.html");
        } else if (isOpenApiInput) {
            LOG.error("Validate your OpenAPI specification, check that is following 3.0 standard. More info here https://github.com/devonfw/cobigen/wiki/cobigen-openapiplugin#usage");
        }
        throw new InputMismatchException("Your input file is invalid.");
    }

    public static String getUserInput() {
        String userInput = "";
        userInput = inputReader.nextLine();
        return userInput;
    }

    public static boolean yesNoPrompt(String validInputMessage, String invalidInputMessage, String cancelMessage) {
        while (true) {
            String userInput;
            switch (userInput = ValidationUtils.getUserInput()) {
                case "yes": 
                case "y": 
                case "": {
                    LOG.info(validInputMessage);
                    return true;
                }
                case "no": 
                case "n": {
                    LOG.info(cancelMessage);
                    return false;
                }
            }
            LOG.info(invalidInputMessage);
        }
    }
}

