/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.api;

import java.util.Objects;
import net.sf.mmm.util.exception.NlsBundleUtilExceptionRoot;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.lang.base.ComparableComparator;
import net.sf.mmm.util.lang.base.NumberComparator;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.value.api.ValueException;

@Deprecated
public class ValueOutOfRangeException
extends ValueException {
    private static final long serialVersionUID = 3363522277063736719L;
    public static final String MESSAGE_CODE = "ValueOutOfRange";

    protected ValueOutOfRangeException() {
    }

    @Deprecated
    public ValueOutOfRangeException(Number value, Number minimum, Number maximum) {
        this((Object)value, (V)minimum, (V)maximum, (V)null);
    }

    @Deprecated
    public ValueOutOfRangeException(Number value, Number minimum, Number maximum, Object valueSource) {
        this((Object)value, (Comparable)((Object)minimum), (Comparable)((Object)maximum), (Comparable)valueSource);
    }

    public <V> ValueOutOfRangeException(V value, V minimum, V maximum) {
        this((Object)value, minimum, maximum, (V)null);
    }

    public <V> ValueOutOfRangeException(V value, V minimum, V maximum, Object valueSource) {
        super(ValueOutOfRangeException.createMessage(value, minimum, maximum, valueSource));
        if (value instanceof Comparable) {
            this.verifyComparable((Comparable)value, (Comparable)minimum, (Comparable)maximum);
        } else if (value instanceof Number) {
            this.verifyNumber((Number)value, (Number)minimum, (Number)maximum);
        }
    }

    @Deprecated
    public <V extends Comparable> ValueOutOfRangeException(Object valueSource, V value, V minimum, V maximum) {
        super(ValueOutOfRangeException.createMessage(value, minimum, maximum, valueSource));
        this.verifyComparable(value, minimum, maximum);
    }

    private <V extends Comparable> void verifyComparable(V value, V minimum, V maximum) {
        if (minimum != null) {
            if (maximum != null ? !$assertionsDisabled && value.compareTo(minimum) >= 0 && value.compareTo(maximum) <= 0 : !$assertionsDisabled && value.compareTo(minimum) >= 0) {
                throw new AssertionError();
            }
        } else if (maximum != null) {
            assert (value.compareTo(maximum) > 0);
        } else {
            throw new NlsNullPointerException("minimum & maximum");
        }
    }

    private void verifyNumber(Number value, Number minimum, Number maximum) {
        if (minimum != null) {
            if (maximum != null ? !$assertionsDisabled && !(value.doubleValue() >= minimum.doubleValue()) && !(value.doubleValue() <= maximum.doubleValue()) : !$assertionsDisabled && !(value.doubleValue() >= minimum.doubleValue())) {
                throw new AssertionError();
            }
        } else if (maximum != null) {
            assert (value.doubleValue() <= maximum.doubleValue());
        } else {
            throw new NlsNullPointerException("minimum & maximum");
        }
    }

    public static <V> void checkRange(V value, V minimum, V maximum, Object valueSource) throws ValueOutOfRangeException {
        int delta;
        NumberComparator comparator;
        Objects.requireNonNull(value, "value");
        if (value instanceof Comparable) {
            comparator = ComparableComparator.getInstance();
        } else if (value instanceof Number) {
            comparator = NumberComparator.getInstance();
        } else {
            throw new IllegalArgumentException(value.getClass().getName());
        }
        boolean valid = true;
        if (minimum != null && (delta = comparator.compare(value, minimum)) < 0) {
            valid = false;
        }
        if (maximum != null && (delta = comparator.compare(value, maximum)) > 0) {
            valid = false;
        }
        if (!valid) {
            throw new ValueOutOfRangeException((Object)value, minimum, maximum, valueSource);
        }
    }

    @Deprecated
    public static void checkRange(Number value, Number minimum, Number maximum, Object valueSource) throws ValueOutOfRangeException {
        double d = value.doubleValue();
        if (d < minimum.doubleValue() || d > maximum.doubleValue()) {
            if (valueSource == null) {
                throw new ValueOutOfRangeException(value, minimum, maximum);
            }
            throw new ValueOutOfRangeException(value, minimum, maximum, valueSource);
        }
    }

    public static <V> NlsMessage createMessage(V value, V minimum, V maximum, Object valueSource) {
        return ValueOutOfRangeException.createBundle(NlsBundleUtilExceptionRoot.class).errorValueOutOfRange(value, minimum == null ? "\u2212\u221e" : minimum, maximum == null ? "+\u221e" : maximum, valueSource);
    }

    @Override
    public String getCode() {
        return MESSAGE_CODE;
    }
}

