/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import net.sf.mmm.util.collection.base.FilteredIterable;
import net.sf.mmm.util.filter.api.Filter;
import net.sf.mmm.util.filter.base.ConstantFilter;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;
import net.sf.mmm.util.resource.api.BrowsableResource;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.api.ResourcePathNode;
import net.sf.mmm.util.resource.impl.AbstractBrowsableClasspathResource;
import net.sf.mmm.util.resource.impl.AbstractClasspathScanner;
import net.sf.mmm.util.resource.impl.ClassIterable;
import net.sf.mmm.util.resource.impl.ClasspathFile;
import net.sf.mmm.util.resource.impl.ClasspathFolder;

public class ClasspathScannerImpl
extends AbstractClasspathScanner {
    private ReflectionUtil reflectionUtil;
    private Cache cache;

    public ReflectionUtil getReflectionUtil() {
        return this.reflectionUtil;
    }

    @Inject
    public void setReflectionUtil(ReflectionUtil reflectionUtil) {
        this.getInitializationState().requireNotInitilized();
        this.reflectionUtil = reflectionUtil;
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.reflectionUtil == null) {
            this.reflectionUtil = ReflectionUtilImpl.getInstance();
        }
    }

    protected final Cache getCache() {
        Cache currentCache = this.cache;
        if (currentCache == null) {
            this.initCache();
            currentCache = this.cache;
        }
        return currentCache;
    }

    private synchronized void initCache() {
        if (this.cache == null) {
            ClasspathFolder rootFolder = new ClasspathFolder(null, "");
            Set<String> resourceNames = this.reflectionUtil.findResourceNames("", true, ConstantFilter.getInstance(true));
            ArrayList<ClasspathFile> fileList = new ArrayList<ClasspathFile>(resourceNames.size());
            for (String resource : resourceNames) {
                ResourcePathNode<Void> path = ResourcePathNode.create(resource);
                ClasspathFolder parent = this.createFolderRecursive((ResourcePathNode<Void>)path.getParent(), rootFolder);
                ClasspathFile file = new ClasspathFile(parent, path.getName());
                parent.children.add(file);
                fileList.add(file);
            }
            this.cache = new Cache(rootFolder, fileList);
        }
    }

    @Override
    public synchronized void clearCaches() {
        this.cache = null;
    }

    private ClasspathFolder createFolderRecursive(ResourcePathNode<Void> path, ClasspathFolder rootFolder) {
        if (path.isRoot()) {
            return rootFolder;
        }
        ClasspathFolder parent = this.createFolderRecursive((ResourcePathNode<Void>)path.getParent(), rootFolder);
        return parent.getOrCreateChildFolder(path.getName());
    }

    @Override
    public ClasspathFolder getClasspathResource() {
        return this.getCache().getRoot();
    }

    @Override
    public BrowsableResource getClasspathResource(String classpath) {
        return (BrowsableResource)this.getClasspathResource().navigate(classpath, true);
    }

    @Override
    public BrowsableResource getClasspathResource(Package pkg) {
        return this.getClasspathResource(pkg.getName().replace('.', '/'));
    }

    @Override
    public Iterable<? extends BrowsableResource> getClasspathResourceFiles() {
        return this.getCache().getClasspathResourceFiles();
    }

    @Override
    public Iterable<? extends BrowsableResource> getClasspathResourceFiles(Filter<? super BrowsableResource> filter) {
        return new FilteredIterable<BrowsableResource>(this.getCache().getClasspathResourceFiles(), filter);
    }

    @Override
    public Iterable<Class<?>> getClasspathResourceClasses(Filter<String> classnameFilter, Filter<Class<?>> classFilter) {
        return new ClassIterable(this.getCache().getClasspathResourceFiles(), classnameFilter, classFilter);
    }

    @Override
    public String getQualifiedName(DataResource classResource) throws IllegalArgumentException {
        String qualifiedName;
        if (classResource instanceof AbstractBrowsableClasspathResource && (qualifiedName = ((AbstractBrowsableClasspathResource)classResource).getQualifiedName()) != null) {
            return qualifiedName;
        }
        return null;
    }

    @Override
    public <T> Class<T> loadClass(BrowsableResource classResource) throws IllegalArgumentException {
        if (classResource instanceof ClasspathFile) {
            return ((ClasspathFile)classResource).getJavaClass();
        }
        throw new IllegalArgumentException(classResource.getUri());
    }

    protected static class Cache {
        private final ClasspathFolder root;
        private final List<ClasspathFile> classpathResourceFiles;

        public Cache(ClasspathFolder root, List<ClasspathFile> fileList) {
            root.init();
            this.root = root;
            this.classpathResourceFiles = Collections.unmodifiableList(fileList);
        }

        public ClasspathFolder getRoot() {
            return this.root;
        }

        public List<ClasspathFile> getClasspathResourceFiles() {
            return this.classpathResourceFiles;
        }
    }
}

