/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.base.GenericTypeVariable;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;
import net.sf.mmm.util.reflect.base.WrappedTypeVariable;
import org.hibernate.mapping.Collection;

public abstract class AbstractGenericType<T>
implements GenericType<T> {
    protected AbstractGenericType() {
    }

    protected abstract GenericType<?> create(Type var1);

    public abstract GenericType<?> getDefiningType();

    protected GenericTypeVariable<?> wrap(TypeVariable<?> typeVariable) {
        return new WrappedTypeVariable(typeVariable);
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof AbstractGenericType) {
            AbstractGenericType otherType = (AbstractGenericType)other;
            if (this.getType().equals(otherType.getType())) {
                GenericType<?> definingType = this.getDefiningType();
                if (definingType == null) {
                    return otherType.getDefiningType() == null;
                }
                return definingType.equals(otherType.getDefiningType());
            }
        }
        return false;
    }

    public final int hashCode() {
        int hash = this.getType().hashCode();
        GenericType<?> definingType = this.getDefiningType();
        if (definingType != null) {
            hash = hash * 31 + definingType.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isAssignableFrom(GenericType<?> subType) {
        block7: {
            Class<?> subTypeUpperBound;
            Class upperBound = this.getRetrievalClass();
            if (!upperBound.isAssignableFrom(subTypeUpperBound = subType.getRetrievalClass())) {
                return false;
            }
            Class lowerBound = this.getAssignmentClass();
            Class subTypeLowerBound = subType.getAssignmentClass();
            if (!(lowerBound == upperBound && subTypeLowerBound == subTypeUpperBound || subTypeLowerBound.isAssignableFrom(lowerBound))) {
                return false;
            }
            int argCount = this.getTypeArgumentCount();
            if (argCount <= 0) break block7;
            if (upperBound == subTypeUpperBound) {
                int subTypeArgCount = subType.getTypeArgumentCount();
                if (subTypeArgCount != argCount) {
                    return false;
                }
                for (int argIndex = 0; argIndex < argCount; ++argIndex) {
                    GenericType<?> subTypeArgument;
                    GenericType<?> typeArgument = this.getTypeArgument(argIndex);
                    if (typeArgument.isAssignableFrom(subTypeArgument = subType.getTypeArgument(argIndex))) continue;
                    return false;
                }
            } else {
                for (TypeVariable typeVariable : upperBound.getTypeParameters()) {
                    GenericType<?> resolvedGenericSubType;
                    Type resolvedType = this.resolveTypeVariable(typeVariable, this);
                    Type resolvedSubType = this.resolveTypeVariable(typeVariable, subType);
                    GenericType<?> resolvedGenericType = this.create(resolvedType);
                    if (resolvedGenericType.isAssignableFrom(resolvedGenericSubType = this.create(resolvedSubType))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isMap() {
        return this.getKeyType() != null;
    }

    @Override
    public boolean isCollection() {
        return this.getComponentType() != null && Collection.class.isAssignableFrom(this.getAssignmentClass());
    }

    protected List<Type> getGenericDeclarations(Class<?> ancestor, Class<?> descendant) {
        ArrayList<Type> declarations;
        block7: {
            Class<?> child;
            if (!ancestor.isAssignableFrom(descendant)) {
                return null;
            }
            declarations = new ArrayList<Type>();
            if (ancestor == descendant) break block7;
            if (ancestor.isInterface()) {
                while (child != ancestor) {
                    Class<?>[] interfaces = child.getInterfaces();
                    Class<?> superInterface = null;
                    for (int i = 0; i < interfaces.length; ++i) {
                        Class<?> currentInterface = interfaces[i];
                        if (!ancestor.isAssignableFrom(currentInterface)) continue;
                        superInterface = currentInterface;
                        Type genericDeclaration = child.getGenericInterfaces()[i];
                        declarations.add(genericDeclaration);
                        break;
                    }
                    if (superInterface == null) {
                        declarations.add(child.getGenericSuperclass());
                        child = child.getSuperclass();
                        continue;
                    }
                    child = superInterface;
                }
            } else {
                for (child = descendant; child != ancestor; child = child.getSuperclass()) {
                    Type genericDeclaration = child.getGenericSuperclass();
                    declarations.add(genericDeclaration);
                }
            }
        }
        return declarations;
    }

    protected int getDeclarationIndex(TypeVariable<?> typeVariable) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        TypeVariable<?>[] variables = genericDeclaration.getTypeParameters();
        for (int variableIndex = 0; variableIndex < variables.length; ++variableIndex) {
            if (variables[variableIndex] != typeVariable) continue;
            return variableIndex;
        }
        return -1;
    }

    protected Type resolveTypeVariable(TypeVariable<?> typeVariable, GenericType<?> declaringType) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        if (genericDeclaration instanceof Class) {
            Class declaringClass = (Class)genericDeclaration;
            return this.resolveTypeVariable(typeVariable, declaringType, declaringClass);
        }
        return null;
    }

    private Type resolveTypeVariable(TypeVariable<?> typeVariable, GenericType<?> declaringType, Class<?> declaringClass) {
        GenericType<?> definingType;
        List<Type> hierarchy = this.getGenericDeclarations(declaringClass, declaringType.getRetrievalClass());
        if (hierarchy != null) {
            TypeVariable currentVariable = typeVariable;
            for (int i = hierarchy.size() - 1; i >= -1; --i) {
                Type hierarchyType = i >= 0 ? hierarchy.get(i) : declaringType.getType();
                if (!(hierarchyType instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)hierarchyType;
                Type[] typeArguments = pt.getActualTypeArguments();
                int variableIndex = this.getDeclarationIndex(currentVariable);
                if (variableIndex < 0) continue;
                Type typeArgument = typeArguments[variableIndex];
                if (typeArgument instanceof TypeVariable) {
                    currentVariable = (TypeVariable)typeArgument;
                    continue;
                }
                return typeArgument;
            }
            if (currentVariable != typeVariable) {
                return currentVariable;
            }
        }
        if ((definingType = ((AbstractGenericType)declaringType).getDefiningType()) != null) {
            return this.resolveTypeVariable(typeVariable, definingType, declaringClass);
        }
        return null;
    }

    @Override
    public final String toString() {
        Type type = this.getType();
        Class upperBound = this.getRetrievalClass();
        if (upperBound == type) {
            if (upperBound.isArray()) {
                return upperBound.getComponentType().getName() + "[]";
            }
            return upperBound.getName();
        }
        return type.toString();
    }

    @Override
    public String toStringSimple() {
        return ReflectionUtilImpl.getInstance().toStringSimple(this);
    }
}

