/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.lang.reflect.Method;
import net.sf.mmm.util.nls.base.NlsArgumentDescriptor;
import net.sf.mmm.util.nls.base.NlsBundleHelper;

public class NlsMessageDescriptor {
    private final Method method;
    private final String key;
    private final String message;
    private NlsArgumentDescriptor[] arguments;

    NlsMessageDescriptor(Method method) {
        this.method = method;
        this.message = NlsBundleHelper.INSTANCE.getMessage(method);
        this.key = NlsBundleHelper.INSTANCE.getKey(method);
    }

    public NlsMessageDescriptor(String key, String message, NlsArgumentDescriptor[] arguments) {
        this.method = null;
        this.key = key;
        this.message = message;
        this.arguments = arguments;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getKey() {
        return this.key;
    }

    public String getMessage() {
        return this.message;
    }

    private NlsArgumentDescriptor[] getArguments() {
        if (this.arguments == null) {
            this.arguments = this.method == null ? NlsArgumentDescriptor.EMPTY_ARRAY : NlsBundleHelper.INSTANCE.getArguments(this.method);
        }
        return this.arguments;
    }

    public NlsArgumentDescriptor getArgument(int index) {
        return this.getArguments()[index];
    }

    public int getArgumentCount() {
        return this.getArguments().length;
    }

    public NlsArgumentDescriptor getArgument(String argumentKey) {
        for (NlsArgumentDescriptor arg : this.getArguments()) {
            if (!arg.getKey().equals(argumentKey)) continue;
            return arg;
        }
        return null;
    }
}

