/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.lang.api.BasicHelper;
import net.sf.mmm.util.lang.api.Formatter;
import net.sf.mmm.util.lang.api.StringSyntax;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.base.FormatterToString;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;
import net.sf.mmm.util.scanner.base.SimpleCharScannerSyntax;
import net.sf.mmm.util.value.api.ValueConverter;
import net.sf.mmm.util.value.base.ValueConverterIdentity;

public class StringUtilImpl
implements StringUtil {
    private static StringUtil instance;
    private static final char[] SEPARATORS;
    private static final char[] HEX;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StringUtil getInstance() {
        if (instance != null) return instance;
        Class<StringUtilImpl> clazz = StringUtilImpl.class;
        synchronized (StringUtilImpl.class) {
            if (instance != null) return instance;
            instance = new StringUtilImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getLineSeparator() {
        return BasicHelper.getSystemProperty("line.separator");
    }

    @Override
    public Boolean parseBoolean(String booleanValue) {
        if (TRUE.equalsIgnoreCase(booleanValue)) {
            return Boolean.TRUE;
        }
        if (FALSE.equalsIgnoreCase(booleanValue)) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public void replace(char[] string, char oldChar, char newChar) {
        for (int i = 0; i < string.length; ++i) {
            if (string[i] != oldChar) continue;
            string[i] = newChar;
        }
    }

    @Override
    public String replace(String string, String match, String replace) {
        int matchLen = match.length();
        int replaceLen = replace.length();
        int delta = replaceLen - matchLen;
        delta = delta < 0 ? 0 : (delta += delta);
        StringBuilder result = new StringBuilder(string.length() + delta);
        int oldPos = 0;
        int pos = string.indexOf(match);
        while (pos >= 0) {
            if (pos > oldPos) {
                result.append(string.substring(oldPos, pos));
            }
            result.append(replace);
            oldPos = pos + matchLen;
            pos = string.indexOf(match, oldPos);
        }
        if (oldPos < string.length()) {
            result.append(string.substring(oldPos));
        }
        return result.toString();
    }

    @Override
    public boolean isSubstring(String string, String substring, int offset) {
        int stringLength = string.length();
        int substringLength = substring.length();
        int end = substringLength + offset;
        if (end <= stringLength) {
            return string.substring(offset, end).equals(substring);
        }
        return false;
    }

    @Override
    public boolean isSubstring(char[] string, String substring, int offset) {
        int substringLength = substring.length();
        if (substringLength + offset <= string.length) {
            for (int i = 0; i < substringLength; ++i) {
                if (string[i + offset] == substring.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String replaceSuffixWithCase(String string, int suffixLength, String newSuffixLowerCase) {
        return this.replaceSuffixWithCase(string, suffixLength, newSuffixLowerCase, Locale.ENGLISH);
    }

    @Override
    public String replaceSuffixWithCase(String string, int suffixLength, String newSuffixLowerCase, Locale locale) {
        int stringLength = string.length();
        int newSuffixLength = newSuffixLowerCase.length();
        int replaceIndex = stringLength - suffixLength;
        if (replaceIndex < 0) {
            replaceIndex = 0;
        }
        StringBuilder result = new StringBuilder(replaceIndex + newSuffixLength);
        if (replaceIndex > 0) {
            result.append(string.substring(0, replaceIndex));
        }
        if (suffixLength > 0) {
            char c = string.charAt(replaceIndex);
            if (c == Character.toLowerCase(c)) {
                result.append(newSuffixLowerCase);
            } else if (suffixLength > 1) {
                c = string.charAt(replaceIndex + 1);
                if (c == Character.toLowerCase(c)) {
                    String first = newSuffixLowerCase.substring(0, 1);
                    String capital = BasicHelper.toUpperCase(first, locale);
                    if (capital.length() == 1) {
                        result.append(newSuffixLowerCase);
                        result.setCharAt(replaceIndex, capital.charAt(0));
                    } else {
                        result.append(capital);
                        result.append(newSuffixLowerCase.substring(1));
                    }
                } else {
                    result.append(BasicHelper.toUpperCase(newSuffixLowerCase, locale));
                }
            }
        }
        return result.toString();
    }

    @Override
    public boolean isEmpty(String string) {
        return this.isEmpty(string, true);
    }

    @Override
    public boolean isEmpty(String string, boolean trim) {
        if (string == null) {
            return true;
        }
        String s = trim ? string.trim() : string;
        return s.length() == 0;
    }

    @Override
    public boolean isAllLowerCase(String string) {
        if (string != null) {
            for (char c : string.toCharArray()) {
                if (Character.toLowerCase(c) == c) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isAllUpperCase(String string) {
        if (string != null) {
            for (char c : string.toCharArray()) {
                if (Character.toUpperCase(c) == c) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String padNumber(long number, int digits) {
        return this.padNumber(number, digits, 10);
    }

    @Override
    public String padNumber(long number, int digits, int radix) {
        String result = Long.toString(number, radix);
        int leadingZeros = digits - result.length();
        if (leadingZeros > 0) {
            int capacity = result.length() + leadingZeros;
            StringBuilder buffer = new StringBuilder(capacity);
            while (leadingZeros > 0) {
                buffer.append('0');
                --leadingZeros;
            }
            buffer.append(result);
            result = buffer.toString();
        }
        return result;
    }

    @Override
    public String toCamlCase(String string) {
        return this.toCamlCase(string, SEPARATORS);
    }

    @Override
    public String toCamlCase(String string, char ... separators) {
        char[] chars = string.toCharArray();
        StringBuilder buffer = new StringBuilder(chars.length);
        int pos = 0;
        boolean lastSeparator = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            boolean isSeparator = false;
            for (char s : separators) {
                if (c != s) continue;
                isSeparator = true;
                break;
            }
            if (isSeparator) {
                lastSeparator = true;
                if (pos < i) {
                    buffer.append(chars, pos, i - pos);
                }
                pos = i + 1;
                continue;
            }
            if (!lastSeparator) continue;
            buffer.append(Character.toUpperCase(c));
            ++pos;
            lastSeparator = false;
        }
        if (!lastSeparator) {
            buffer.append(chars, pos, chars.length - pos);
        }
        return buffer.toString();
    }

    @Override
    public String fromCamlCase(String string, char separator) {
        char[] chars = string.toCharArray();
        StringBuilder buffer = new StringBuilder(chars.length + 4);
        boolean lastCharWasLowerCase = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            char lower = Character.toLowerCase(c);
            if (c == lower) {
                lastCharWasLowerCase = Character.isLowerCase(c);
            } else {
                if (lastCharWasLowerCase) {
                    buffer.append(separator);
                }
                lastCharWasLowerCase = false;
            }
            buffer.append(lower);
        }
        return buffer.toString();
    }

    @Override
    public String toSeparatedString(Collection<?> collection, String separator, StringSyntax syntax) {
        FormatterToString formatter = FormatterToString.getInstance();
        return this.toSeparatedString(collection, separator, syntax, formatter);
    }

    @Override
    public <E> String toSeparatedString(Collection<E> collection, String separator, StringSyntax syntax, Formatter<E> formatter) {
        StringBuilder buffer = new StringBuilder();
        this.toSeparatedString(collection, separator, syntax, formatter, buffer);
        return buffer.toString();
    }

    @Override
    public <E> void toSeparatedString(Collection<E> collection, String separator, StringSyntax syntax, Formatter<E> formatter, Appendable buffer) {
        NlsNullPointerException.checkNotNull("separator", separator);
        if (separator.length() == 0) {
            throw new NlsIllegalArgumentException((Object)separator, "separator");
        }
        try {
            char escape = syntax.getEscape();
            char start = syntax.getQuoteStart();
            char end = syntax.getQuoteEnd();
            char separatorChar = separator.charAt(0);
            String occurrence = null;
            String replacement = null;
            if (escape != '\u0000') {
                occurrence = end != '\u0000' ? Character.toString(end) : Character.toString(separatorChar);
                replacement = escape + occurrence;
            }
            boolean notStart = false;
            for (E element : collection) {
                if (notStart) {
                    buffer.append(separator);
                }
                notStart = true;
                if (start != '\u0000') {
                    buffer.append(start);
                }
                if (escape == '\u0000') {
                    formatter.format(element, buffer);
                } else {
                    String elementString = formatter.format(element);
                    elementString = elementString.replace(occurrence, replacement);
                    buffer.append(elementString);
                }
                if (end == '\u0000') continue;
                buffer.append(end);
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }

    @Override
    public List<String> fromSeparatedString(CharSequence separatedString, String separator, StringSyntax syntax) {
        ArrayList<String> result = new ArrayList<String>();
        this.fromSeparatedString(separatedString, separator, syntax, result);
        return result;
    }

    @Override
    public void fromSeparatedString(CharSequence separatedString, String separator, StringSyntax syntax, Collection<String> collection) {
        ValueConverterIdentity<String> identityConverter = new ValueConverterIdentity<String>(String.class);
        this.fromSeparatedString(separatedString, separator, syntax, collection, identityConverter);
    }

    @Override
    public <E> void fromSeparatedString(CharSequence separatedString, String separator, StringSyntax syntax, Collection<E> collection, ValueConverter<String, E> converter) {
        this.fromSeparatedString(separatedString, separator, syntax, collection, converter, converter.getTargetType());
    }

    @Override
    public <E> void fromSeparatedString(CharSequence separatedString, String separator, StringSyntax syntax, Collection<E> collection, ValueConverter<? super String, ? super E> converter, Class<E> type) {
        NlsNullPointerException.checkNotNull("separator", separator);
        if (separator.length() == 0) {
            throw new NlsIllegalArgumentException((Object)separator, "separator");
        }
        if (separatedString == null) {
            return;
        }
        CharSequenceScanner scanner = new CharSequenceScanner(separatedString);
        char escape = syntax.getEscape();
        char start = syntax.getQuoteStart();
        char end = syntax.getQuoteEnd();
        char separatorChar = separator.charAt(0);
        SimpleCharScannerSyntax scannerSyntax = new SimpleCharScannerSyntax();
        scannerSyntax.setEscape(escape);
        while (scanner.hasNext()) {
            String elementString;
            if (start != '\u0000') {
                scanner.require(start);
            }
            if (end == '\u0000') {
                elementString = scanner.readUntil(separatorChar, true, scannerSyntax);
                scanner.stepBack();
                if (scanner.peek() == separatorChar) {
                    scanner.require(separator, false);
                } else {
                    scanner.next();
                    assert (!scanner.hasNext());
                }
            } else {
                elementString = scanner.readUntil(end, false, scannerSyntax);
                if (scanner.hasNext()) {
                    scanner.require(separator, false);
                }
            }
            if (elementString == null) {
                StringBuilder format = new StringBuilder();
                if (start != '\u0000') {
                    format.append('\'');
                    format.append(start);
                    format.append('\'');
                }
                format.append(" <value> ");
                if (end != '\u0000') {
                    format.append('\'');
                    format.append(end);
                    format.append('\'');
                }
                String value = format.toString();
                format.append(" ['");
                format.append(separator);
                format.append("' ");
                format.append(value);
                format.append("]*");
                throw new NlsParseException(separatedString, (CharSequence)format, collection.getClass());
            }
            E element = converter.convert(elementString, (Object)separatedString, type);
            collection.add(element);
        }
    }

    @Override
    public String toHex(byte[] data) {
        char[] buffer = new char[data.length * 2];
        int i = 0;
        for (byte b : data) {
            buffer[i++] = HEX[(b & 0xF0) >> 4];
            buffer[i++] = HEX[b & 0xF];
        }
        return new String(buffer);
    }

    static {
        SEPARATORS = new char[]{' ', '-', '_', '.'};
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

