/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.lang.api.CharIterator;
import net.sf.mmm.util.lang.base.AbstractCharIterator;

public class SpaceNormalizingCharIterator
extends AbstractCharIterator {
    private final CharIterator delegate;
    private final CharFilter spaceFilter;
    private final boolean trim;
    private char next;
    private boolean foundNonWhitespace;

    public SpaceNormalizingCharIterator(CharIterator delegate) {
        this(delegate, CharFilter.WHITESPACE_FILTER, true);
    }

    public SpaceNormalizingCharIterator(CharIterator delegate, CharFilter spaceFilter, boolean trim) {
        this.delegate = delegate;
        this.spaceFilter = spaceFilter;
        this.trim = trim;
        this.next = (char)65279;
        this.findFirst();
    }

    @Override
    protected char findNext() {
        char result;
        if (this.next != '\ufeff') {
            result = this.next;
            this.next = (char)65279;
        } else {
            result = this.delegate.next();
            if (result != '\ufeff' && this.spaceFilter.accept(result)) {
                do {
                    this.next = this.delegate.next();
                } while (this.next != '\ufeff' && this.spaceFilter.accept(this.next));
                if (this.trim & (!this.foundNonWhitespace || this.next != '\ufeff')) {
                    result = this.next;
                    this.next = (char)65279;
                }
            } else {
                this.foundNonWhitespace = true;
            }
        }
        return result;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

