/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.mmm.util.collection.base.EmptyIterator;
import net.sf.mmm.util.resource.api.BrowsableResource;
import net.sf.mmm.util.resource.api.ResourceNotAvailableException;
import net.sf.mmm.util.resource.api.ResourceNotWritableException;
import net.sf.mmm.util.resource.base.AbstractBrowsableResource;

public class FileResource
extends AbstractBrowsableResource {
    public static final String SCHEME_PREFIX = "file://";
    private final File file;

    public FileResource(File file) {
        this.file = file;
    }

    public FileResource(String filePath) {
        this(new File(filePath));
    }

    @Override
    public String getSchemePrefix() {
        return SCHEME_PREFIX;
    }

    @Override
    public String getPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public long getSize() throws ResourceNotAvailableException {
        if (!this.isAvailable()) {
            throw new ResourceNotAvailableException(this.getPath());
        }
        return this.file.length();
    }

    @Override
    public InputStream openStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotAvailableException((Throwable)e, this.getPath());
        }
    }

    @Override
    public OutputStream openOutputStream() throws ResourceNotWritableException {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotWritableException((Throwable)e, this.getPath());
        }
    }

    @Override
    public URL getUrl() throws ResourceNotAvailableException {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ResourceNotAvailableException(this.getPath());
        }
    }

    @Override
    public String getUri() {
        return SCHEME_PREFIX + this.file.getAbsolutePath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean isData() {
        return this.file.exists() && !this.file.isDirectory();
    }

    @Override
    public boolean isFolder() {
        return this.file.isDirectory();
    }

    @Override
    public Date getLastModificationDate() {
        long lastModified = this.file.lastModified();
        if (lastModified != 0L) {
            return new Date(lastModified);
        }
        return null;
    }

    @Override
    public BrowsableResource navigate(String resourcePath) {
        File parent = this.file.getParentFile();
        return new FileResource(new File(parent, resourcePath));
    }

    @Override
    public BrowsableResource cd(String path) {
        return new FileResource(new File(this.file, path));
    }

    public Iterable<BrowsableResource> getChildResources() {
        return new FileResourceIterable();
    }

    protected static class FileResourceIterator
    implements Iterator<BrowsableResource> {
        private final File[] files;
        private int index;

        public FileResourceIterator(File[] files) {
            this.files = files;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.files.length;
        }

        @Override
        public FileResource next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new FileResource(this.files[this.index++]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class FileResourceIterable
    implements Iterable<BrowsableResource> {
        @Override
        public Iterator<BrowsableResource> iterator() {
            if (!FileResource.this.file.isDirectory()) {
                return EmptyIterator.getInstance();
            }
            File[] files = FileResource.this.file.listFiles();
            return new FileResourceIterator(files);
        }
    }
}

