/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.mmm.util.nls.base.AbstractNlsTemplate;
import net.sf.mmm.util.nls.base.NlsBundleHelper;

public class NlsTemplateImpl
extends AbstractNlsTemplate {
    private static final long serialVersionUID = -312035648040124881L;
    private String name;
    private String key;

    protected NlsTemplateImpl() {
    }

    public NlsTemplateImpl(String name, String key) {
        this.name = name;
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String translate(Locale locale) {
        try {
            ResourceBundle bundle = NlsBundleHelper.getInstance().getResourceBundle(this.name, locale);
            return bundle.getString(this.key);
        }
        catch (Exception e) {
            return this.translateFallback(e);
        }
    }

    protected String translateFallback(Exception e) {
        String messageId = this.name + ":" + this.key;
        this.getLogger().warn("Failed to resolve message (" + messageId + "): " + e.getMessage());
        return this.translateFallback(messageId);
    }

    protected String translateFallback(String messageId) {
        return "unresolved (" + messageId + ")";
    }

    public String toString() {
        return this.name + ":" + this.key;
    }
}

