/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.lang.api.Alignment;
import net.sf.mmm.util.lang.api.SimpleDatatype;

public enum VerticalAlignment implements SimpleDatatype<String>
{
    TOP("^", "top"),
    BOTTOM("_", "bottom"),
    CENTER("-", "center");

    private final String value;
    private final String title;

    private VerticalAlignment(String value, String title) {
        this.value = value;
        this.title = title;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public Alignment getAlignment() {
        switch (this) {
            case TOP: {
                return Alignment.TOP;
            }
            case CENTER: {
                return Alignment.CENTER;
            }
            case BOTTOM: {
                return Alignment.BOTTOM;
            }
        }
        throw new IllegalCaseException(VerticalAlignment.class, this);
    }

    @Override
    public String toString() {
        return this.title;
    }

    public static VerticalAlignment fromValue(String value) {
        for (VerticalAlignment alignment : VerticalAlignment.values()) {
            if (!alignment.value.equals(value)) continue;
            return alignment;
        }
        return null;
    }
}

