/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.filter.base;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import net.sf.mmm.util.filter.api.Filter;
import net.sf.mmm.util.filter.api.FilterRule;
import net.sf.mmm.util.filter.base.PatternFilterRule;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class FilterRuleChain<V>
implements Filter<V> {
    @XmlID
    @XmlAttribute(name="id")
    private String id;
    @XmlIDREF
    @XmlAttribute(name="parent")
    private FilterRuleChain<V> parent;
    @XmlElement(name="rule", type=PatternFilterRule.class)
    private FilterRule<V>[] rules;
    @XmlAttribute(name="default-result", required=false)
    private boolean defaultResult;

    public FilterRuleChain() {
    }

    @SafeVarargs
    public FilterRuleChain(boolean defaultResult, FilterRule<V> ... rules) {
        this.rules = rules;
        this.defaultResult = defaultResult;
    }

    @SafeVarargs
    public FilterRuleChain(String id, FilterRuleChain<V> parent, boolean defaultResult, FilterRule<V> ... rules) {
        this.id = id;
        this.parent = parent;
        this.rules = rules;
        this.defaultResult = defaultResult;
    }

    public boolean getDefaultResult() {
        return this.defaultResult;
    }

    @Override
    public boolean accept(V value) {
        Boolean result = this.acceptRecursive(value);
        if (result == null) {
            return this.defaultResult;
        }
        return result;
    }

    private Boolean acceptRecursive(V value) {
        Boolean result = null;
        if (this.parent != null && (result = super.acceptRecursive(value)) != null) {
            return result;
        }
        for (FilterRule<V> rule : this.rules) {
            result = rule.accept(value);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public FilterRuleChain<V> extend(boolean newDefaultResult, FilterRule<V> ... additionalRules) {
        FilterRule[] newRules = new FilterRule[this.rules.length + additionalRules.length];
        System.arraycopy(this.rules, 0, newRules, 0, this.rules.length);
        System.arraycopy(additionalRules, 0, newRules, this.rules.length, additionalRules.length);
        return new FilterRuleChain<V>(newDefaultResult, newRules);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        int len = 0;
        if (this.rules != null) {
            len = this.rules.length;
        }
        return FilterRuleChain.class.getSimpleName() + "[" + this.id + "][" + len + "]";
    }
}

