/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.cli.utils;

import com.devonfw.cobigen.cli.CobiGenCLI;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsingUtils {
    private static Logger LOG = LoggerFactory.getLogger(CobiGenCLI.class);

    public static boolean parseRelativePath(List<File> inputFiles, File inputFile, int index) {
        try {
            Path inputFilePath = Paths.get(System.getProperty("user.dir"), inputFile.toString());
            if (inputFilePath.toFile().exists()) {
                inputFiles.set(index, inputFilePath.toFile());
                return true;
            }
        }
        catch (InvalidPathException e) {
            LOG.debug("The path string {} {} cannot be converted to a path", (Object)System.getProperty("user.dir"), (Object)inputFile.toString());
        }
        return false;
    }

    public static void formatJavaSources(Set<Path> generatedFiles) throws FormatterException {
        Set<Path> filesToFormat = generatedFiles;
        Formatter formatter = new Formatter();
        Iterator<Path> itr = filesToFormat.iterator();
        LOG.info("Formatting code...");
        while (itr.hasNext()) {
            Path generatedFilePath = itr.next();
            try {
                String unformattedCode = new String(Files.readAllBytes(generatedFilePath));
                String formattedCode = formatter.formatSource(unformattedCode);
                Files.write(generatedFilePath, formattedCode.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Unable to read or write the generated file {} when trying to format it", (Object)generatedFilePath.toString());
                return;
            }
        }
        LOG.info("Finished successfully");
    }
}

