/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.constructor.ConstructorResolverStrategy;
import ma.glasnost.orika.impl.GeneratedObjectFactory;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.UsedConvertersContext;
import ma.glasnost.orika.impl.generator.UsedMapperFacadesContext;
import ma.glasnost.orika.impl.generator.UsedTypesContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFactoryGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectFactoryGenerator.class);
    private final ConstructorResolverStrategy constructorResolverStrategy;
    private final MapperFactory mapperFactory;
    private final String nameSuffix;

    public ObjectFactoryGenerator(MapperFactory mapperFactory, ConstructorResolverStrategy constructorResolverStrategy, CompilerStrategy compilerStrategy) {
        this.mapperFactory = mapperFactory;
        this.nameSuffix = String.valueOf(System.nanoTime());
        this.constructorResolverStrategy = constructorResolverStrategy;
    }

    public GeneratedObjectFactory build(Type<?> type, Type<?> sourceType, MappingContext context) {
        String className = type.getSimpleName() + "_" + sourceType.getSimpleName() + "_ObjectFactory" + this.nameSuffix;
        className = ObjectFactoryGenerator.prependPackageName(ObjectFactoryGenerator.getPackageName(type), className);
        try {
            StringBuilder logDetails;
            if (LOGGER.isDebugEnabled()) {
                logDetails = new StringBuilder();
                logDetails.append("Generating new object factory for (" + type + ")");
            } else {
                logDetails = null;
            }
            SourceCodeContext factoryCode = new SourceCodeContext(className, GeneratedObjectFactory.class, context, logDetails);
            UsedTypesContext usedTypes = new UsedTypesContext();
            UsedConvertersContext usedConverters = new UsedConvertersContext();
            UsedMapperFacadesContext usedMapperFacades = new UsedMapperFacadesContext();
            this.addCreateMethod(factoryCode, usedTypes, usedConverters, usedMapperFacades, type, sourceType, context, logDetails);
            GeneratedObjectFactory objectFactory = (GeneratedObjectFactory)factoryCode.getInstance();
            objectFactory.setMapperFacade(this.mapperFactory.getMapperFacade());
            if (logDetails != null) {
                LOGGER.debug(logDetails.toString());
            }
            return objectFactory;
        }
        catch (Exception e) {
            if (e instanceof MappingException) {
                throw (MappingException)e;
            }
            throw new MappingException("exception while creating object factory for " + type.getName(), e);
        }
    }

    private static String getPackageName(Type<?> type) {
        Package typePackage = ((Class)type.getRawType()).getPackage();
        return typePackage == null ? "" : typePackage.getName();
    }

    private static String prependPackageName(String packageName, String className) {
        return packageName.isEmpty() || packageName.startsWith("java.") ? className : packageName + "." + className;
    }

    private void addCreateMethod(SourceCodeContext code, UsedTypesContext usedTypes, UsedConvertersContext usedConverters, UsedMapperFacadesContext usedMappers, Type<?> type, Type<?> sourceType, MappingContext mappingContext, StringBuilder logDetails) {
        StringBuilder out = new StringBuilder();
        out.append("public Object create(Object s, " + MappingContext.class.getCanonicalName() + " mappingContext) {");
        out.append(String.format("if(s == null) throw new %s(\"source object must be not null\");", IllegalArgumentException.class.getCanonicalName()));
        out.append(this.addSourceClassConstructor(code, type, sourceType, mappingContext, logDetails));
        out.append(this.addUnmatchedSourceHandler(code, type, sourceType, mappingContext, logDetails));
        out.append("\n}");
        code.addMethod(out.toString());
    }

    private String addSourceClassConstructor(SourceCodeContext code, Type<?> destinationType, Type<?> sourceType, MappingContext mappingContext, StringBuilder logDetails) {
        MapperKey mapperKey = new MapperKey(sourceType, destinationType);
        ClassMap classMap = this.mapperFactory.getClassMap(mapperKey);
        if (classMap == null) {
            classMap = this.mapperFactory.getClassMap(new MapperKey(destinationType, sourceType));
        }
        StringBuilder out = new StringBuilder();
        if (classMap != null) {
            if (destinationType.isArray()) {
                out.append(this.addArrayClassConstructor(code, destinationType, sourceType, classMap.getFieldsMapping().size()));
            } else {
                out.append(String.format("if (s instanceof %s) {", sourceType.getCanonicalName()));
                out.append(String.format("%s source = (%s) s;", sourceType.getCanonicalName(), sourceType.getCanonicalName()));
                out.append("\ntry {\n");
                ConstructorResolverStrategy.ConstructorMapping<?> constructorMapping = this.constructorResolverStrategy.resolve(classMap, destinationType);
                Constructor<?> constructor = constructorMapping.getConstructor();
                if (constructor == null) {
                    throw new IllegalArgumentException("no suitable constructors found for " + destinationType);
                }
                if (logDetails != null) {
                    logDetails.append("\n\tUsing constructor: " + constructor);
                }
                List<FieldMap> properties = constructorMapping.getMappedFields();
                Type<?>[] constructorArguments = constructorMapping.getParameterTypes();
                if (constructorArguments == null || properties.size() != constructorArguments.length) {
                    throw new MappingException("While attempting to generate ObjectFactory using constructor '" + constructor + "', an automatic mapping of the source type ('" + sourceType + "') to this constructor call could not be determined. Please register a custom ObjectFactory implementation which is able to create an instance of '" + destinationType + "' from an instance of '" + sourceType + "'.");
                }
                int argIndex = 0;
                argIndex = 0;
                for (FieldMap fieldMap : properties) {
                    VariableRef v = new VariableRef(constructorArguments[argIndex], "arg" + argIndex++);
                    VariableRef s = new VariableRef(fieldMap.getSource(), "source");
                    VariableRef destOwner = new VariableRef(fieldMap.getDestination(), "");
                    v.setOwner(destOwner);
                    out.append(SourceCodeContext.statement(v.declare(), new Object[0]));
                    out.append(code.mapFields(fieldMap, s, v));
                }
                out.append(String.format("return new %s(", destinationType.getCanonicalName()));
                for (int i = 0; i < properties.size(); ++i) {
                    out.append(String.format("arg%d", i));
                    if (i >= properties.size() - 1) continue;
                    out.append(",");
                }
                out.append(");");
                SourceCodeContext.append(out, "\n} catch (java.lang.Exception e) {\n", "if (e instanceof RuntimeException) {\n", "throw (RuntimeException)e;\n", "} else {", "throw new java.lang.RuntimeException(\"Error while constructing new " + destinationType.getSimpleName() + " instance\", e);", "\n}\n}\n}");
            }
        }
        return out.toString();
    }

    private String addUnmatchedSourceHandler(SourceCodeContext code, Type<?> type, Type<?> sourceType, MappingContext mappingContext, StringBuilder logDetails) {
        StringBuilder out = new StringBuilder();
        for (Constructor<?> constructor : ((Class)type.getRawType()).getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            out.append(String.format("return new %s();", type.getCanonicalName()));
            break;
        }
        if (out.length() == 0) {
            for (Constructor<?> constructor : ((Class)type.getRawType()).getConstructors()) {
                Type argType;
                if (constructor.getParameterTypes().length != 1 || !Modifier.isPublic(constructor.getModifiers()) || !(argType = TypeFactory.valueOf(constructor.getGenericParameterTypes()[0])).isAssignableFrom(sourceType)) continue;
                out.append(String.format("return new %s((%s)s);", type.getCanonicalName(), sourceType.getCanonicalName()));
                break;
            }
        }
        if (out.length() == 0) {
            out.append(String.format("throw new %s(s.getClass().getCanonicalName() + \" is an unsupported source class for constructing instances of " + type.getCanonicalName() + "\");", IllegalArgumentException.class.getCanonicalName()));
        }
        return out.toString();
    }

    private String addArrayClassConstructor(SourceCodeContext code, Type<?> type, Type<?> sourceType, int size) {
        return String.format("if (s instanceof %s) {", sourceType.getCanonicalName()) + "return new " + ((Class)type.getRawType()).getComponentType().getCanonicalName() + "[" + size + "];\n}";
    }
}

