/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.cli.commands;

import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import com.devonfw.cobigen.cli.CobiGenCLI;
import com.devonfw.cobigen.cli.commands.CommandCommons;
import com.devonfw.cobigen.cli.commands.GenerateCommand;
import com.devonfw.cobigen.cli.utils.CobiGenUtils;
import com.devonfw.cobigen.cli.utils.PluginUpdateUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Use update command to find out which plug-ins are outdated and choose which ones do you want to update ."}, name="update", aliases={"u"}, mixinStandardHelpOptions=true)
public class UpdateCommand
extends CommandCommons {
    private static Logger LOG = LoggerFactory.getLogger(CobiGenCLI.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+\\.[0-9]+\\.[0-9]+)(-[a-zA-Z]+)?");
    @CommandLine.Option(names={"--all"}, negatable=true, description={"If this option is enabled, all plugins will get updated."})
    boolean updateAll;

    @Override
    public Integer doAction() throws Exception {
        File pomFile = CobiGenUtils.extractArtificialPom();
        HashMap<String, String> updatePluginVersions = new HashMap<String, String>();
        HashMap<Integer, String> listOfArtifacts = new HashMap<Integer, String>();
        ArrayList<String> centralMavenVersionList = new ArrayList<String>();
        ArrayList<String> userInputPluginForUpdate = new ArrayList<String>();
        if (pomFile.exists()) {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            try (FileReader fr = new FileReader(pomFile);){
                Model model = reader.read((Reader)fr);
                List localPomDependencies = model.getDependencies();
                boolean isAllUpdated = this.printOutdatedPlugin(localPomDependencies, centralMavenVersionList, updatePluginVersions, listOfArtifacts);
                if (isAllUpdated) {
                    Integer n = 0;
                    return n;
                }
                if (this.updateAll) {
                    userInputPluginForUpdate.add("0");
                    LOG.info("(0) ALL is selected!");
                } else {
                    this.userInputPluginSelection(userInputPluginForUpdate);
                    if (userInputPluginForUpdate.size() == 1 && !StringUtils.isNumeric((CharSequence)userInputPluginForUpdate.get(0))) {
                        LOG.info("Nothing selected to update...");
                        Integer n = 0;
                        return n;
                    }
                }
                LOG.info("Updating the following components:");
                this.updateOutdatedPlugins(localPomDependencies, listOfArtifacts, centralMavenVersionList, model, userInputPluginForUpdate);
                try (FileWriter fw = new FileWriter(pomFile);){
                    MavenXpp3Writer writer = new MavenXpp3Writer();
                    writer.write((Writer)fw, model);
                }
            }
            LOG.info("Updated successfully. Next time you generate, the plug-ins will be downloaded.");
            return 0;
        }
        return 1;
    }

    private void userInputPluginSelection(ArrayList<String> userInputPluginForUpdate) {
        for (String userArtifact : GenerateCommand.getUserInput().split(",")) {
            userInputPluginForUpdate.add(userArtifact);
        }
    }

    public boolean printOutdatedPlugin(List<Dependency> localPomDependencies, List<String> centralMavenVersionList, HashMap<String, String> updatePluginVersions, HashMap<Integer, String> listOfArtifacts) {
        int count = 0;
        String centralMavenVersion = "";
        String requiresUpdate = "";
        block0: for (Dependency lclDependencies : localPomDependencies) {
            if (!this.dependencyShouldBeUpdated(lclDependencies.getGroupId())) continue;
            centralMavenVersion = PluginUpdateUtil.latestPluginVersion(lclDependencies.getArtifactId());
            String[] centralVersionValues = this.extractVersionFragments(centralMavenVersion);
            String[] localVersion = this.extractVersionFragments(lclDependencies.getVersion());
            for (int ver = 0; ver < localVersion.length; ++ver) {
                if (Integer.parseInt(localVersion[ver]) >= Integer.parseInt(centralVersionValues[ver])) continue;
                if (count == 0) {
                    LOG.info("(0) All");
                }
                ++count;
                centralMavenVersionList.add(centralMavenVersion);
                requiresUpdate = lclDependencies.getArtifactId();
                updatePluginVersions.put(lclDependencies.getArtifactId(), centralVersionValues[ver]);
                listOfArtifacts.put(count, requiresUpdate);
                LOG.info("({}) {}, {} -> {}", new Object[]{count, requiresUpdate, lclDependencies.getVersion(), centralMavenVersion});
                continue block0;
            }
        }
        if (count == 0) {
            LOG.info("All plug-ins are up to date...");
            return true;
        }
        LOG.info("Here are the components that can be updated, which ones do you want to  update? Please list the number of artifact(s) to update separated by comma:");
        return false;
    }

    private String[] extractVersionFragments(String version) {
        Matcher lclMatcher = VERSION_PATTERN.matcher(version);
        if (!lclMatcher.find()) {
            throw new CobiGenRuntimeException("unable to match version " + version + " against version pattern " + VERSION_PATTERN.pattern());
        }
        String[] localVersion = lclMatcher.group(1).split("\\.");
        return localVersion;
    }

    public void updateOutdatedPlugins(List<Dependency> localPomDependencies, HashMap<Integer, String> listOfArtifacts, List<String> centralMavenVersionList, Model model, ArrayList<String> userInputPluginForUpdate) {
        int all = 0;
        for (int j = 0; j < userInputPluginForUpdate.size(); ++j) {
            String digitMatch;
            String currentSelectedArtifact = userInputPluginForUpdate.get(j);
            if (!currentSelectedArtifact.matches(digitMatch = "\\d+")) continue;
            int selectedArtifactNumber = Integer.parseInt(currentSelectedArtifact);
            int index = selectedArtifactNumber - 1;
            if (selectedArtifactNumber == 0) {
                for (Dependency lclDependencies : localPomDependencies) {
                    if (!listOfArtifacts.containsValue(lclDependencies.getArtifactId())) continue;
                    LOG.info("{} -> {}", (Object)lclDependencies.getArtifactId(), (Object)centralMavenVersionList.get(all));
                    lclDependencies.setVersion(centralMavenVersionList.get(all));
                    ++all;
                }
                model.setDependencies(localPomDependencies);
                continue;
            }
            String plugin = listOfArtifacts.get(selectedArtifactNumber);
            LOG.info("({}) {} -> {}", new Object[]{selectedArtifactNumber, plugin, centralMavenVersionList.get(index)});
            for (Dependency selectedDependencies : localPomDependencies) {
                if (!plugin.equals(selectedDependencies.getArtifactId())) continue;
                selectedDependencies.setVersion(centralMavenVersionList.get(index));
            }
            model.setDependencies(localPomDependencies);
        }
    }

    private boolean dependencyShouldBeUpdated(String groupId) {
        return "com.devonfw.cobigen".equals(groupId);
    }
}

