/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import net.sf.mmm.util.component.base.AbstractComponent;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.xml.api.ParserState;
import net.sf.mmm.util.xml.api.XmlUtil;
import net.sf.mmm.util.xml.base.XmlInputStream;

public class XmlUtilImpl
extends AbstractComponent
implements XmlUtil {
    private static XmlUtil instance;
    private static final Map<String, Character> ENTITY_MAP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmlUtil getInstance() {
        if (instance != null) return instance;
        Class<XmlUtilImpl> clazz = XmlUtilImpl.class;
        synchronized (XmlUtilImpl.class) {
            if (instance != null) return instance;
            XmlUtilImpl util = new XmlUtilImpl();
            util.initialize();
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public Reader createXmlReader(InputStream inputStream) {
        return this.createXmlReader(inputStream, Charset.defaultCharset());
    }

    @Override
    public Reader createXmlReader(InputStream inputStream, Charset defaultCharset) {
        try {
            XmlInputStream streamAdapter = new XmlInputStream(inputStream, defaultCharset);
            return new InputStreamReader((InputStream)streamAdapter, streamAdapter.getCharset());
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.READ);
        }
    }

    @Override
    public String escapeXml(String string, boolean escapeQuotations) {
        if (string == null) {
            return null;
        }
        StringWriter writer = new StringWriter(string.length() + 8);
        this.escapeXml(string, writer, escapeQuotations);
        return writer.toString();
    }

    @Override
    public void escapeXml(String string, Writer writer, boolean escapeQuotations) {
        try {
            char[] chars;
            if (string == null) {
                writer.append("null");
                return;
            }
            for (char c : chars = string.toCharArray()) {
                if (c >= '\u0080') {
                    writer.append("&#");
                    writer.append(Integer.toString(c));
                    writer.append(";");
                    continue;
                }
                if (c == '&') {
                    writer.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    writer.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    writer.append("&gt;");
                    continue;
                }
                if (escapeQuotations && c == '\'') {
                    writer.append("&#39;");
                    continue;
                }
                if (escapeQuotations && c == '\"') {
                    writer.append("&quot;");
                    continue;
                }
                writer.append(c);
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }

    @Override
    public Character resolveEntity(String entityName) {
        return ENTITY_MAP.get(entityName);
    }

    @Override
    public ParserState extractPlainText(String htmlFragment, StringBuilder buffer, ParserState parserState) {
        int len = htmlFragment.length();
        int tagStartIndex = 0;
        int cdataCloseCount = 0;
        char inAttribute = '\u0000';
        if (parserState != null) {
            if (parserState.getTagStartIndex() != 0) {
                tagStartIndex = -1;
            }
            cdataCloseCount = parserState.getCdataCloseCount();
            inAttribute = parserState.getInAttribute();
        }
        for (int i = 0; i < len; ++i) {
            char c = htmlFragment.charAt(i);
            if (tagStartIndex > 0) {
                String substring;
                int tagLen = i - tagStartIndex;
                if (tagLen == 2) {
                    String substring2 = htmlFragment.substring(tagStartIndex, i);
                    if (substring2.toLowerCase().equals("br") && (c == ' ' || c == '/' || c == '>')) {
                        buffer.append('\n');
                    }
                } else if (tagLen == 8 && "![CDATA[".equals(substring = htmlFragment.substring(tagStartIndex, i))) {
                    cdataCloseCount = 3;
                }
            }
            if (cdataCloseCount > 0) {
                if (c == ']' && cdataCloseCount > 1) {
                    --cdataCloseCount;
                    continue;
                }
                if (c == '>' && cdataCloseCount == 1) {
                    cdataCloseCount = 0;
                    continue;
                }
                if (cdataCloseCount == 3) {
                    buffer.append(c);
                    continue;
                }
                buffer.append(']');
                if (cdataCloseCount == 1) {
                    buffer.append(']');
                }
                cdataCloseCount = 3;
                continue;
            }
            if (c == '<') {
                tagStartIndex = i + 1;
                continue;
            }
            if (c == '>') {
                if (inAttribute != '\u0000') continue;
                tagStartIndex = 0;
                continue;
            }
            if (tagStartIndex == 0) {
                if (c == '&') {
                    int lookaheadIndex;
                    int end = i + 10;
                    if (end > len) {
                        end = len;
                    }
                    boolean semicolonFound = false;
                    for (lookaheadIndex = i + 1; lookaheadIndex < end; ++lookaheadIndex) {
                        if (htmlFragment.charAt(lookaheadIndex) != ';') continue;
                        semicolonFound = true;
                        break;
                    }
                    if (semicolonFound) {
                        if (htmlFragment.charAt(i + 1) == '#') {
                            String codepoint = htmlFragment.substring(i + 2, lookaheadIndex);
                            try {
                                int code = Integer.parseInt(codepoint);
                                c = (char)code;
                            }
                            catch (NumberFormatException e) {
                                c = '\ufffd';
                            }
                            buffer.append(c);
                        } else {
                            String entityName = htmlFragment.substring(i + 1, lookaheadIndex);
                            Character value = this.resolveEntity(entityName);
                            c = value != null ? (char)value.charValue() : (char)'\ufffd';
                            buffer.append(c);
                        }
                        i = lookaheadIndex;
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c != '\"' && c != '\'') continue;
            if (inAttribute == '\u0000') {
                inAttribute = c;
                continue;
            }
            if (inAttribute != c) continue;
            inAttribute = '\u0000';
        }
        ParserState state = new ParserState();
        state.setTagStartIndex(tagStartIndex);
        state.setInAttribute(inAttribute);
        state.setCdataCloseCount(cdataCloseCount);
        return state;
    }

    static {
        ENTITY_MAP = new HashMap<String, Character>(256);
        ENTITY_MAP.put("quot", Character.valueOf('\"'));
        ENTITY_MAP.put("amp", Character.valueOf('&'));
        ENTITY_MAP.put("lt", Character.valueOf('<'));
        ENTITY_MAP.put("gt", Character.valueOf('>'));
        ENTITY_MAP.put("apos", Character.valueOf('\''));
        ENTITY_MAP.put("nbsp", Character.valueOf('\u00a0'));
        ENTITY_MAP.put("iexcl", Character.valueOf('\u00a1'));
        ENTITY_MAP.put("cent", Character.valueOf('\u00a2'));
        ENTITY_MAP.put("pound", Character.valueOf('\u00a3'));
        ENTITY_MAP.put("curren", Character.valueOf('\u00a4'));
        ENTITY_MAP.put("yen", Character.valueOf('\u00a5'));
        ENTITY_MAP.put("brvbar", Character.valueOf('\u00a6'));
        ENTITY_MAP.put("sect", Character.valueOf('\u00a7'));
        ENTITY_MAP.put("uml", Character.valueOf('\u00a8'));
        ENTITY_MAP.put("copy", Character.valueOf('\u00a9'));
        ENTITY_MAP.put("ordf", Character.valueOf('\u00aa'));
        ENTITY_MAP.put("laquo", Character.valueOf('\u00ab'));
        ENTITY_MAP.put("not", Character.valueOf('\u00ac'));
        ENTITY_MAP.put("shy", Character.valueOf('\u00ad'));
        ENTITY_MAP.put("reg", Character.valueOf('\u00ae'));
        ENTITY_MAP.put("macr", Character.valueOf('\u00af'));
        ENTITY_MAP.put("deg", Character.valueOf('\u00b0'));
        ENTITY_MAP.put("plusmn", Character.valueOf('\u00b1'));
        ENTITY_MAP.put("sup2", Character.valueOf('\u00b2'));
        ENTITY_MAP.put("sup3", Character.valueOf('\u00b3'));
        ENTITY_MAP.put("acute", Character.valueOf('\u00b4'));
        ENTITY_MAP.put("micro", Character.valueOf('\u00b5'));
        ENTITY_MAP.put("para", Character.valueOf('\u00b6'));
        ENTITY_MAP.put("middot", Character.valueOf('\u00b7'));
        ENTITY_MAP.put("cedil", Character.valueOf('\u00b8'));
        ENTITY_MAP.put("sup1", Character.valueOf('\u00b9'));
        ENTITY_MAP.put("ordm", Character.valueOf('\u00ba'));
        ENTITY_MAP.put("raquo", Character.valueOf('\u00bb'));
        ENTITY_MAP.put("frac14", Character.valueOf('\u00bc'));
        ENTITY_MAP.put("frac12", Character.valueOf('\u00bd'));
        ENTITY_MAP.put("frac34", Character.valueOf('\u00be'));
        ENTITY_MAP.put("iquest", Character.valueOf('\u00bf'));
        ENTITY_MAP.put("Agrave", Character.valueOf('\u00c0'));
        ENTITY_MAP.put("Aacute", Character.valueOf('\u00c1'));
        ENTITY_MAP.put("Acirc", Character.valueOf('\u00c2'));
        ENTITY_MAP.put("Atilde", Character.valueOf('\u00c3'));
        ENTITY_MAP.put("Auml", Character.valueOf('\u00c4'));
        ENTITY_MAP.put("Aring", Character.valueOf('\u00c5'));
        ENTITY_MAP.put("AElig", Character.valueOf('\u00c6'));
        ENTITY_MAP.put("Ccedil", Character.valueOf('\u00c7'));
        ENTITY_MAP.put("Egrave", Character.valueOf('\u00c8'));
        ENTITY_MAP.put("Eacute", Character.valueOf('\u00c9'));
        ENTITY_MAP.put("Ecirc", Character.valueOf('\u00ca'));
        ENTITY_MAP.put("Euml", Character.valueOf('\u00cb'));
        ENTITY_MAP.put("Igrave", Character.valueOf('\u00cc'));
        ENTITY_MAP.put("Iacute", Character.valueOf('\u00cd'));
        ENTITY_MAP.put("Icirc", Character.valueOf('\u00ce'));
        ENTITY_MAP.put("Iuml", Character.valueOf('\u00cf'));
        ENTITY_MAP.put("ETH", Character.valueOf('\u00d0'));
        ENTITY_MAP.put("Ntilde", Character.valueOf('\u00d1'));
        ENTITY_MAP.put("Ograve", Character.valueOf('\u00d2'));
        ENTITY_MAP.put("Oacute", Character.valueOf('\u00d3'));
        ENTITY_MAP.put("Ocirc", Character.valueOf('\u00d4'));
        ENTITY_MAP.put("Otilde", Character.valueOf('\u00d5'));
        ENTITY_MAP.put("Ouml", Character.valueOf('\u00d6'));
        ENTITY_MAP.put("times", Character.valueOf('\u00d7'));
        ENTITY_MAP.put("Oslash", Character.valueOf('\u00d8'));
        ENTITY_MAP.put("Ugrave", Character.valueOf('\u00d9'));
        ENTITY_MAP.put("Uacute", Character.valueOf('\u00da'));
        ENTITY_MAP.put("Ucirc", Character.valueOf('\u00db'));
        ENTITY_MAP.put("Uuml", Character.valueOf('\u00dc'));
        ENTITY_MAP.put("Yacute", Character.valueOf('\u00dd'));
        ENTITY_MAP.put("THORN", Character.valueOf('\u00de'));
        ENTITY_MAP.put("szlig", Character.valueOf('\u00df'));
        ENTITY_MAP.put("agrave", Character.valueOf('\u00e0'));
        ENTITY_MAP.put("aacute", Character.valueOf('\u00e1'));
        ENTITY_MAP.put("acirc", Character.valueOf('\u00e2'));
        ENTITY_MAP.put("atilde", Character.valueOf('\u00e3'));
        ENTITY_MAP.put("auml", Character.valueOf('\u00e4'));
        ENTITY_MAP.put("aring", Character.valueOf('\u00e5'));
        ENTITY_MAP.put("aelig", Character.valueOf('\u00e6'));
        ENTITY_MAP.put("ccedil", Character.valueOf('\u00e7'));
        ENTITY_MAP.put("egrave", Character.valueOf('\u00e8'));
        ENTITY_MAP.put("eacute", Character.valueOf('\u00e9'));
        ENTITY_MAP.put("ecirc", Character.valueOf('\u00ea'));
        ENTITY_MAP.put("euml", Character.valueOf('\u00eb'));
        ENTITY_MAP.put("igrave", Character.valueOf('\u00ec'));
        ENTITY_MAP.put("iacute", Character.valueOf('\u00ed'));
        ENTITY_MAP.put("icirc", Character.valueOf('\u00ee'));
        ENTITY_MAP.put("iuml", Character.valueOf('\u00ef'));
        ENTITY_MAP.put("eth", Character.valueOf('\u00f0'));
        ENTITY_MAP.put("ntilde", Character.valueOf('\u00f1'));
        ENTITY_MAP.put("ograve", Character.valueOf('\u00f2'));
        ENTITY_MAP.put("oacute", Character.valueOf('\u00f3'));
        ENTITY_MAP.put("ocirc", Character.valueOf('\u00f4'));
        ENTITY_MAP.put("otilde", Character.valueOf('\u00f5'));
        ENTITY_MAP.put("ouml", Character.valueOf('\u00f6'));
        ENTITY_MAP.put("divide", Character.valueOf('\u00f7'));
        ENTITY_MAP.put("oslash", Character.valueOf('\u00f8'));
        ENTITY_MAP.put("ugrave", Character.valueOf('\u00f9'));
        ENTITY_MAP.put("uacute", Character.valueOf('\u00fa'));
        ENTITY_MAP.put("ucirc", Character.valueOf('\u00fb'));
        ENTITY_MAP.put("uuml", Character.valueOf('\u00fc'));
        ENTITY_MAP.put("yacute", Character.valueOf('\u00fd'));
        ENTITY_MAP.put("thorn", Character.valueOf('\u00fe'));
        ENTITY_MAP.put("yuml", Character.valueOf('\u00ff'));
        ENTITY_MAP.put("fnof", Character.valueOf('\u0192'));
        ENTITY_MAP.put("Alpha", Character.valueOf('\u0391'));
        ENTITY_MAP.put("Beta", Character.valueOf('\u0392'));
        ENTITY_MAP.put("Gamma", Character.valueOf('\u0393'));
        ENTITY_MAP.put("Delta", Character.valueOf('\u0394'));
        ENTITY_MAP.put("Epsilon", Character.valueOf('\u0395'));
        ENTITY_MAP.put("Zeta", Character.valueOf('\u0396'));
        ENTITY_MAP.put("Eta", Character.valueOf('\u0397'));
        ENTITY_MAP.put("Theta", Character.valueOf('\u0398'));
        ENTITY_MAP.put("Iota", Character.valueOf('\u0399'));
        ENTITY_MAP.put("Kappa", Character.valueOf('\u039a'));
        ENTITY_MAP.put("Lambda", Character.valueOf('\u039b'));
        ENTITY_MAP.put("Mu", Character.valueOf('\u039c'));
        ENTITY_MAP.put("Nu", Character.valueOf('\u039d'));
        ENTITY_MAP.put("Xi", Character.valueOf('\u039e'));
        ENTITY_MAP.put("Omicron", Character.valueOf('\u039f'));
        ENTITY_MAP.put("Pi", Character.valueOf('\u03a0'));
        ENTITY_MAP.put("Rho", Character.valueOf('\u03a1'));
        ENTITY_MAP.put("Sigma", Character.valueOf('\u03a3'));
        ENTITY_MAP.put("Tau", Character.valueOf('\u03a4'));
        ENTITY_MAP.put("Upsilon", Character.valueOf('\u03a5'));
        ENTITY_MAP.put("Phi", Character.valueOf('\u03a6'));
        ENTITY_MAP.put("Chi", Character.valueOf('\u03a7'));
        ENTITY_MAP.put("Psi", Character.valueOf('\u03a8'));
        ENTITY_MAP.put("Omega", Character.valueOf('\u03a9'));
        ENTITY_MAP.put("alpha", Character.valueOf('\u03b1'));
        ENTITY_MAP.put("beta", Character.valueOf('\u03b2'));
        ENTITY_MAP.put("gamma", Character.valueOf('\u03b3'));
        ENTITY_MAP.put("delta", Character.valueOf('\u03b4'));
        ENTITY_MAP.put("epsilon", Character.valueOf('\u03b5'));
        ENTITY_MAP.put("zeta", Character.valueOf('\u03b6'));
        ENTITY_MAP.put("eta", Character.valueOf('\u03b7'));
        ENTITY_MAP.put("theta", Character.valueOf('\u03b8'));
        ENTITY_MAP.put("iota", Character.valueOf('\u03b9'));
        ENTITY_MAP.put("kappa", Character.valueOf('\u03ba'));
        ENTITY_MAP.put("lambda", Character.valueOf('\u03bb'));
        ENTITY_MAP.put("mu", Character.valueOf('\u03bc'));
        ENTITY_MAP.put("nu", Character.valueOf('\u03bd'));
        ENTITY_MAP.put("xi", Character.valueOf('\u03be'));
        ENTITY_MAP.put("omicron", Character.valueOf('\u03bf'));
        ENTITY_MAP.put("pi", Character.valueOf('\u03c0'));
        ENTITY_MAP.put("rho", Character.valueOf('\u03c1'));
        ENTITY_MAP.put("sigmaf", Character.valueOf('\u03c2'));
        ENTITY_MAP.put("sigma", Character.valueOf('\u03c3'));
        ENTITY_MAP.put("tau", Character.valueOf('\u03c4'));
        ENTITY_MAP.put("upsilon", Character.valueOf('\u03c5'));
        ENTITY_MAP.put("phi", Character.valueOf('\u03c6'));
        ENTITY_MAP.put("chi", Character.valueOf('\u03c7'));
        ENTITY_MAP.put("psi", Character.valueOf('\u03c8'));
        ENTITY_MAP.put("omega", Character.valueOf('\u03c9'));
        ENTITY_MAP.put("thetasym", Character.valueOf('\u03d1'));
        ENTITY_MAP.put("upsih", Character.valueOf('\u03d2'));
        ENTITY_MAP.put("piv", Character.valueOf('\u03d6'));
        ENTITY_MAP.put("bull", Character.valueOf('\u2022'));
        ENTITY_MAP.put("hellip", Character.valueOf('\u2026'));
        ENTITY_MAP.put("prime", Character.valueOf('\u2032'));
        ENTITY_MAP.put("Prime", Character.valueOf('\u2033'));
        ENTITY_MAP.put("oline", Character.valueOf('\u203e'));
        ENTITY_MAP.put("frasl", Character.valueOf('\u2044'));
        ENTITY_MAP.put("weierp", Character.valueOf('\u2118'));
        ENTITY_MAP.put("image", Character.valueOf('\u2111'));
        ENTITY_MAP.put("real", Character.valueOf('\u211c'));
        ENTITY_MAP.put("trade", Character.valueOf('\u2122'));
        ENTITY_MAP.put("alefsym", Character.valueOf('\u2135'));
        ENTITY_MAP.put("larr", Character.valueOf('\u2190'));
        ENTITY_MAP.put("uarr", Character.valueOf('\u2191'));
        ENTITY_MAP.put("rarr", Character.valueOf('\u2192'));
        ENTITY_MAP.put("darr", Character.valueOf('\u2193'));
        ENTITY_MAP.put("harr", Character.valueOf('\u2194'));
        ENTITY_MAP.put("crarr", Character.valueOf('\u21b5'));
        ENTITY_MAP.put("lArr", Character.valueOf('\u21d0'));
        ENTITY_MAP.put("uArr", Character.valueOf('\u21d1'));
        ENTITY_MAP.put("rArr", Character.valueOf('\u21d2'));
        ENTITY_MAP.put("dArr", Character.valueOf('\u21d3'));
        ENTITY_MAP.put("hArr", Character.valueOf('\u21d4'));
        ENTITY_MAP.put("forall", Character.valueOf('\u2200'));
        ENTITY_MAP.put("part", Character.valueOf('\u2202'));
        ENTITY_MAP.put("exist", Character.valueOf('\u2203'));
        ENTITY_MAP.put("empty", Character.valueOf('\u2205'));
        ENTITY_MAP.put("nabla", Character.valueOf('\u2207'));
        ENTITY_MAP.put("isin", Character.valueOf('\u2208'));
        ENTITY_MAP.put("notin", Character.valueOf('\u2209'));
        ENTITY_MAP.put("ni", Character.valueOf('\u220b'));
        ENTITY_MAP.put("prod", Character.valueOf('\u220f'));
        ENTITY_MAP.put("sum", Character.valueOf('\u2211'));
        ENTITY_MAP.put("minus", Character.valueOf('\u2212'));
        ENTITY_MAP.put("lowast", Character.valueOf('\u2217'));
        ENTITY_MAP.put("radic", Character.valueOf('\u221a'));
        ENTITY_MAP.put("prop", Character.valueOf('\u221d'));
        ENTITY_MAP.put("infin", Character.valueOf('\u221e'));
        ENTITY_MAP.put("ang", Character.valueOf('\u2220'));
        ENTITY_MAP.put("and", Character.valueOf('\u2227'));
        ENTITY_MAP.put("or", Character.valueOf('\u2228'));
        ENTITY_MAP.put("cap", Character.valueOf('\u2229'));
        ENTITY_MAP.put("cup", Character.valueOf('\u222a'));
        ENTITY_MAP.put("int", Character.valueOf('\u222b'));
        ENTITY_MAP.put("there4", Character.valueOf('\u2234'));
        ENTITY_MAP.put("sim", Character.valueOf('\u223c'));
        ENTITY_MAP.put("cong", Character.valueOf('\u2245'));
        ENTITY_MAP.put("asymp", Character.valueOf('\u2248'));
        ENTITY_MAP.put("ne", Character.valueOf('\u2260'));
        ENTITY_MAP.put("equiv", Character.valueOf('\u2261'));
        ENTITY_MAP.put("le", Character.valueOf('\u2264'));
        ENTITY_MAP.put("ge", Character.valueOf('\u2265'));
        ENTITY_MAP.put("sub", Character.valueOf('\u2282'));
        ENTITY_MAP.put("sup", Character.valueOf('\u2283'));
        ENTITY_MAP.put("sube", Character.valueOf('\u2286'));
        ENTITY_MAP.put("supe", Character.valueOf('\u2287'));
        ENTITY_MAP.put("oplus", Character.valueOf('\u2295'));
        ENTITY_MAP.put("otimes", Character.valueOf('\u2297'));
        ENTITY_MAP.put("perp", Character.valueOf('\u22a5'));
        ENTITY_MAP.put("sdot", Character.valueOf('\u22c5'));
        ENTITY_MAP.put("lceil", Character.valueOf('\u2308'));
        ENTITY_MAP.put("rceil", Character.valueOf('\u2309'));
        ENTITY_MAP.put("lfloor", Character.valueOf('\u230a'));
        ENTITY_MAP.put("rfloor", Character.valueOf('\u230b'));
        ENTITY_MAP.put("lang", Character.valueOf('\u2329'));
        ENTITY_MAP.put("rang", Character.valueOf('\u232a'));
        ENTITY_MAP.put("loz", Character.valueOf('\u25ca'));
        ENTITY_MAP.put("spades", Character.valueOf('\u2660'));
        ENTITY_MAP.put("clubs", Character.valueOf('\u2663'));
        ENTITY_MAP.put("hearts", Character.valueOf('\u2665'));
        ENTITY_MAP.put("diams", Character.valueOf('\u2666'));
        ENTITY_MAP.put("OElig", Character.valueOf('\u0152'));
        ENTITY_MAP.put("oelig", Character.valueOf('\u0153'));
        ENTITY_MAP.put("Scaron", Character.valueOf('\u0160'));
        ENTITY_MAP.put("scaron", Character.valueOf('\u0161'));
        ENTITY_MAP.put("Yuml", Character.valueOf('\u0178'));
        ENTITY_MAP.put("circ", Character.valueOf('\u02c6'));
        ENTITY_MAP.put("tilde", Character.valueOf('\u02dc'));
        ENTITY_MAP.put("ensp", Character.valueOf('\u2002'));
        ENTITY_MAP.put("emsp", Character.valueOf('\u2003'));
        ENTITY_MAP.put("thinsp", Character.valueOf('\u2009'));
        ENTITY_MAP.put("zwnj", Character.valueOf('\u200c'));
        ENTITY_MAP.put("zwj", Character.valueOf('\u200d'));
        ENTITY_MAP.put("lrm", Character.valueOf('\u200e'));
        ENTITY_MAP.put("rlm", Character.valueOf('\u200f'));
        ENTITY_MAP.put("ndash", Character.valueOf('\u2013'));
        ENTITY_MAP.put("mdash", Character.valueOf('\u2014'));
        ENTITY_MAP.put("lsquo", Character.valueOf('\u2018'));
        ENTITY_MAP.put("rsquo", Character.valueOf('\u2019'));
        ENTITY_MAP.put("sbquo", Character.valueOf('\u201a'));
        ENTITY_MAP.put("ldquo", Character.valueOf('\u201c'));
        ENTITY_MAP.put("rdquo", Character.valueOf('\u201d'));
        ENTITY_MAP.put("bdquo", Character.valueOf('\u201e'));
        ENTITY_MAP.put("dagger", Character.valueOf('\u2020'));
        ENTITY_MAP.put("Dagger", Character.valueOf('\u2021'));
        ENTITY_MAP.put("permil", Character.valueOf('\u2030'));
        ENTITY_MAP.put("lsaquo", Character.valueOf('\u2039'));
        ENTITY_MAP.put("rsaquo", Character.valueOf('\u203a'));
        ENTITY_MAP.put("euro", Character.valueOf('\u20ac'));
    }
}

