/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.base;

import net.sf.mmm.util.xml.api.XmlCompareMode;
import net.sf.mmm.util.xml.base.NodeIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class JoiningNodeIterator
extends NodeIterator {
    private final XmlCompareMode compareMode;
    private Node next;

    public JoiningNodeIterator(NodeList nodeList, XmlCompareMode mode) {
        super(nodeList);
        this.compareMode = mode;
    }

    @Override
    protected Node findNext() {
        Node result = this.next;
        this.next = null;
        if (result == null && (result = super.findNext()) != null) {
            short nodeType = result.getNodeType();
            if (!this.compareMode.isCheckComments()) {
                while (nodeType == 8) {
                    result = super.findNext();
                    if (result == null) {
                        nodeType = -1;
                        continue;
                    }
                    nodeType = result.getNodeType();
                }
            }
            if (nodeType == 3 && this.compareMode.isJoinText() || nodeType == 4 && this.compareMode.isJoinCData() || nodeType == 8 && this.compareMode.isJoinComment()) {
                Node currentNode = result;
                result = result.getOwnerDocument().createDocumentFragment();
                short alternativeNodeType = nodeType;
                if (this.compareMode.isJoinText() && this.compareMode.isJoinCData()) {
                    if (nodeType == 3) {
                        alternativeNodeType = 4;
                    } else if (nodeType == 4) {
                        alternativeNodeType = 3;
                    }
                }
                do {
                    short nextNodeType;
                    result.appendChild(currentNode);
                    currentNode = super.findNext();
                    if (currentNode == null || (nextNodeType = currentNode.getNodeType()) == nodeType || nextNodeType == alternativeNodeType) continue;
                    this.next = currentNode;
                    currentNode = null;
                } while (currentNode != null);
            }
        }
        return result;
    }
}

