/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.transformer.base;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import net.sf.mmm.util.transformer.api.StringTransformerRule;
import net.sf.mmm.util.transformer.api.Transformer;
import net.sf.mmm.util.transformer.base.RegexStringTransformerRule;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class StringTransformerChain
implements Transformer<String> {
    @XmlID
    @XmlAttribute(name="id")
    private String id;
    @XmlIDREF
    private StringTransformerChain parent;
    @XmlElement(name="regex", type=RegexStringTransformerRule.class)
    private StringTransformerRule[] rules;

    public StringTransformerChain() {
    }

    public StringTransformerChain(StringTransformerRule ... rules) {
        this.rules = rules;
    }

    public StringTransformerChain(String id, StringTransformerChain parent, StringTransformerRule ... rules) {
        this.id = id;
        this.parent = parent;
        this.rules = rules;
    }

    @Override
    public String transform(String original) {
        return this.transformRecursive(original, new State());
    }

    private String transformRecursive(String original, State state) {
        String value = original;
        if (this.parent != null) {
            value = this.parent.transformRecursive(original, state);
            if (state.stop) {
                return value;
            }
        }
        for (StringTransformerRule rule : this.rules) {
            String transformed = rule.transform(value);
            if (transformed != value && rule.isStopOnMatch()) {
                state.stop = true;
                return transformed;
            }
            value = transformed;
        }
        return value;
    }

    public String getId() {
        return this.id;
    }

    public StringTransformerChain extend(StringTransformerRule ... additionalRules) {
        StringTransformerRule[] newRules = new StringTransformerRule[this.rules.length + additionalRules.length];
        System.arraycopy(this.rules, 0, newRules, 0, this.rules.length);
        System.arraycopy(additionalRules, 0, newRules, this.rules.length, additionalRules.length);
        return new StringTransformerChain(newRules);
    }

    protected static class State {
        private boolean stop = false;

        protected State() {
        }
    }
}

