/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.session.api;

import java.util.Locale;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.session.api.UserSession;
import net.sf.mmm.util.session.base.UserSessionProvider;
import net.sf.mmm.util.session.base.UserSessionProviderDefaultImpl;
import org.slf4j.LoggerFactory;

public final class UserSessionAccess {
    private static UserSessionProvider provider;

    private UserSessionAccess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UserSessionProvider getProvider() {
        if (provider != null) return provider;
        Class<UserSessionAccess> clazz = UserSessionAccess.class;
        synchronized (UserSessionAccess.class) {
            UserSessionProviderDefaultImpl impl = new UserSessionProviderDefaultImpl();
            impl.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setProvider(UserSessionProvider sessionProvder) {
        if (provider != null) {
            LoggerFactory.getLogger(UserSessionAccess.class).warn("ATTENTION: replacing existing UserSessionProvider {} with {}!", (Object)provider, (Object)sessionProvder);
        }
        Class<UserSessionAccess> clazz = UserSessionAccess.class;
        synchronized (UserSessionAccess.class) {
            provider = sessionProvder;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static UserSession getSession() {
        return UserSessionAccess.getProvider().getCurrentSession();
    }

    public static String getUserLogin() {
        return UserSessionAccess.getSession().getLogin();
    }

    public static Locale getUserLocale() {
        return UserSessionAccess.getSession().getLocale();
    }

    public static abstract class AbstractUserSessionProvider
    extends AbstractLoggableComponent
    implements UserSessionProvider {
        @Override
        protected void doInitialized() {
            super.doInitialized();
            UserSessionAccess.setProvider(this);
        }
    }
}

