/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.impl;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.base.AbstractGenericType;
import net.sf.mmm.util.reflect.impl.CommonTypeVariables;
import net.sf.mmm.util.reflect.impl.GenericTypeImpl;

public class SimpleGenericTypeImpl<T>
extends AbstractGenericType<T> {
    public static final GenericType<Object> TYPE_OBJECT = new SimpleGenericTypeImpl<Object>(Object.class);
    public static final GenericType<?> TYPE_VOID = new SimpleGenericTypeImpl<Void>(Void.TYPE);
    public static final GenericType<?> TYPE_INT = new SimpleGenericTypeImpl<Integer>(Integer.TYPE);
    private final Class<T> type;
    private GenericType<?> componentType;
    private GenericType<?> keyType;

    public SimpleGenericTypeImpl(Class<T> type) {
        this.type = type;
        if (type.isArray()) {
            this.componentType = new SimpleGenericTypeImpl(type.getComponentType());
            this.keyType = null;
        } else if (Collection.class.isAssignableFrom(type)) {
            Type resolvedType = this.resolveTypeVariable(CommonTypeVariables.TYPE_VARIABLE_COLLECTION_ELEMENT, this);
            this.componentType = new GenericTypeImpl(resolvedType);
            this.keyType = null;
        } else if (Map.class.isAssignableFrom(type)) {
            Type resolvedType = this.resolveTypeVariable(CommonTypeVariables.TYPE_VARIABLE_MAP_VALUE, this);
            this.componentType = new GenericTypeImpl(resolvedType);
            resolvedType = this.resolveTypeVariable(CommonTypeVariables.TYPE_VARIABLE_MAP_KEY, this);
            this.keyType = new GenericTypeImpl(resolvedType);
        } else {
            this.componentType = null;
            this.keyType = null;
        }
    }

    @Override
    protected GenericType<?> create(Type genericType) {
        return new GenericTypeImpl(genericType);
    }

    @Override
    public GenericType<?> getDefiningType() {
        return null;
    }

    @Override
    public GenericType<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public GenericType<?> getKeyType() {
        return this.keyType;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<T> getAssignmentClass() {
        return this.type;
    }

    @Override
    public Class<T> getRetrievalClass() {
        return this.type;
    }

    @Override
    public GenericType<?> getTypeArgument(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public int getTypeArgumentCount() {
        return 0;
    }
}

