/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Class<?> rawType;
    private final Type ownerType;
    private final Type[] actualTypeArguments;

    public ParameterizedTypeImpl(Class<?> rawType, Type[] typeArguments, Type ownerType) {
        this.rawType = rawType;
        this.ownerType = ownerType;
        this.actualTypeArguments = typeArguments;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public boolean equals(Object other) {
        if (other instanceof ParameterizedType) {
            ParameterizedType otherType = (ParameterizedType)other;
            if (this == otherType) {
                return true;
            }
            Type otherOwner = otherType.getOwnerType();
            boolean result = this.ownerType == null ? otherOwner == null : this.ownerType.equals(otherOwner);
            result = result && this.rawType.equals(otherType.getRawType()) && Arrays.equals(this.actualTypeArguments, otherType.getActualTypeArguments());
            return result;
        }
        return false;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(this.actualTypeArguments);
        if (this.rawType != null) {
            hash ^= this.rawType.hashCode();
        }
        if (this.ownerType != null) {
            hash ^= this.ownerType.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.ownerType != null) {
            result.append(ReflectionUtilImpl.getInstance().toString(this.ownerType));
            result.append('.');
            result.append(this.rawType.getName());
        } else {
            result.append(this.rawType.getName());
        }
        if (this.actualTypeArguments.length > 0) {
            result.append('<');
            for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                Type typeArgument = this.actualTypeArguments[i];
                if (i > 0) {
                    result.append(", ");
                }
                if (typeArgument instanceof Class) {
                    result.append(((Class)typeArgument).getName());
                    continue;
                }
                result.append(typeArgument.toString());
            }
            result.append('>');
        }
        return result.toString();
    }
}

