/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pattern.base;

import net.sf.mmm.util.pattern.api.PatternCompiler;
import net.sf.mmm.util.pattern.base.AbstractGlobPatternCompiler;

public class PathPatternCompiler
extends AbstractGlobPatternCompiler {
    public static final PatternCompiler INSTANCE = new PathPatternCompiler();

    @Override
    protected int process(char[] chars, int charIndex, StringBuilder buffer) {
        int next = charIndex + 1;
        char c = chars[charIndex];
        if (c == '*') {
            if (next < chars.length && chars[next] == '*') {
                if (++next < chars.length && chars[next] == '/') {
                    buffer.append("(|.*[/\\\\])");
                    return ++next;
                }
                buffer.append(".*");
                return next;
            }
            buffer.append("[^/\\\\]+");
        } else if (c == '?') {
            buffer.append("[^/\\\\]");
        } else if (c == '/') {
            buffer.append("[/\\\\]");
        } else {
            return super.process(chars, charIndex, buffer);
        }
        return next;
    }
}

