/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl.formatter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.filter.api.Filter;
import net.sf.mmm.util.filter.base.ConjunctionCharFilter;
import net.sf.mmm.util.filter.base.ListCharFilter;
import net.sf.mmm.util.lang.api.CompareOperator;
import net.sf.mmm.util.lang.api.Conjunction;
import net.sf.mmm.util.nls.api.NlsArgument;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;
import net.sf.mmm.util.nls.base.AbstractNlsFormatterPlugin;
import net.sf.mmm.util.nls.base.NlsDependencies;
import net.sf.mmm.util.nls.impl.formatter.NlsFormatterChoiceNoElseConditionException;
import net.sf.mmm.util.nls.impl.formatter.NlsFormatterChoiceOnlyElseConditionException;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;

public final class NlsFormatterChoice
extends AbstractNlsFormatterPlugin<Object> {
    private static final String REQUIRED_FORMAT_SEGMENTS = "({...}|'.*'])+";
    private static final String REQUIRED_FORMAT_COMPARATOR = "(==|!=|>=|>|<=|<)";
    private static final String REQUIRED_FORMAT_CONDITION = "(else|?(==|!=|>=|>|<=|<)[0-9a-zA-Z+-.:])";
    public static final char CONDITION_START = '(';
    public static final char CONDITION_END = ')';
    public static final char CONDITION_VAR = '?';
    public static final String CONDITION_ELSE = "else";
    private static final Filter<Object> FILTER_ELSE = new Condition(null, null);
    private static final CharFilter FILTER_COMPARATOR = new ListCharFilter(true, '<', '=', '>', '!');
    private static final CharFilter FILTER_COMPARATOR_ARGUMENT = new ConjunctionCharFilter(Conjunction.OR, CharFilter.LATIN_DIGIT_OR_LETTER_FILTER, new ListCharFilter(true, '-', '+', '.', ':'));
    private final NlsDependencies nlsDependencies;
    private final List<Choice> choices;

    public NlsFormatterChoice(CharSequenceScanner scanner, NlsDependencies nlsDependencies) {
        this.nlsDependencies = nlsDependencies;
        this.choices = new ArrayList<Choice>();
        boolean hasElse = false;
        char c = scanner.forceNext();
        while (c == '(' && !hasElse) {
            Choice choice = this.parseChoice(scanner);
            if (choice.condition == FILTER_ELSE) {
                hasElse = true;
            }
            this.choices.add(choice);
            c = scanner.forceNext();
        }
        if (!hasElse) {
            throw new NlsFormatterChoiceNoElseConditionException();
        }
        if (this.choices.size() < 2) {
            throw new NlsFormatterChoiceOnlyElseConditionException();
        }
        scanner.stepBack();
    }

    private Choice parseChoice(CharSequenceScanner scanner) {
        Filter<Object> condition = this.parseCondition(scanner);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        while (scanner.hasNext()) {
            int index = scanner.getCurrentIndex();
            char c = scanner.peek();
            String literal = null;
            if (c == '\"' || c == '\'') {
                scanner.next();
                literal = scanner.readUntil(c, false, c);
                if (literal == null) {
                    throw new NlsParseException(scanner.substring(index, scanner.getCurrentIndex()), (CharSequence)REQUIRED_FORMAT_SEGMENTS, NlsArgument.class);
                }
                c = scanner.peek();
            }
            NlsArgument argument = null;
            if (c == '{') {
                scanner.next();
                argument = this.nlsDependencies.getArgumentParser().parse(scanner);
            }
            if (argument == null && literal == null) break;
            segments.add(new Segment(literal, argument));
        }
        return new Choice(condition, segments);
    }

    private Filter<Object> parseCondition(CharSequenceScanner scanner) {
        Condition condition;
        int index = scanner.getCurrentIndex();
        if (scanner.expect('?')) {
            String symbol = scanner.readWhile(FILTER_COMPARATOR);
            CompareOperator comparator = CompareOperator.fromValue(symbol);
            if (comparator == null) {
                throw new NlsParseException(symbol, (CharSequence)REQUIRED_FORMAT_COMPARATOR, CompareOperator.class);
            }
            Object comparatorArgument = this.parseComparatorArgument(scanner);
            condition = new Condition(comparator, comparatorArgument);
        } else if (scanner.expect(CONDITION_ELSE, false)) {
            condition = FILTER_ELSE;
        } else {
            throw new NlsParseException(scanner.substring(index, scanner.getCurrentIndex()), (CharSequence)REQUIRED_FORMAT_CONDITION, (Object)this.getType());
        }
        if (!scanner.expect(')')) {
            throw new NlsParseException(scanner.substring(index, scanner.getCurrentIndex()), (CharSequence)REQUIRED_FORMAT_CONDITION, (Object)this.getType());
        }
        return condition;
    }

    private Object parseComparatorArgument(CharSequenceScanner scanner) {
        Comparable<Comparable<Boolean>> comparatorArgument;
        int index = scanner.getCurrentIndex();
        char c = scanner.forcePeek();
        if (c == '\"' || c == '\'') {
            scanner.next();
            comparatorArgument = scanner.readUntil(c, false, c);
        } else {
            String argument = scanner.readWhile(FILTER_COMPARATOR_ARGUMENT);
            if (argument.length() == 0) {
                throw new NlsParseException(scanner.substring(index, scanner.getCurrentIndex()), (CharSequence)REQUIRED_FORMAT_CONDITION, (Object)this.getType());
            }
            comparatorArgument = "null".equals(argument) ? null : (argument.matches("([0-9][0-9][0-9][0-9])[-]?([0-1][0-9])[-]?([0-3][0-9])(T([0-2][0-9])[:]?([0-5][0-9])[:]?([0-5][0-9])((([+-])([0-2][0-9])[:]?([0-5][0-9])([:]?([0-5][0-9]))?|Z))?)?") ? this.nlsDependencies.getIso8601Util().parseDate(argument) : (Boolean.TRUE.toString().equals(argument) ? Boolean.TRUE : (Boolean.FALSE.toString().equals(argument) ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)Double.valueOf(argument))));
        }
        return comparatorArgument;
    }

    @Override
    public void format(Object object, Locale locale, Map<String, Object> arguments, NlsTemplateResolver resolver, Appendable buffer) throws IOException {
        for (Choice choice : this.choices) {
            if (!choice.condition.accept(object)) continue;
            for (Segment segment : choice.segments) {
                buffer.append(segment.literal);
                if (segment.argument == null) continue;
                this.nlsDependencies.getArgumentFormatter().format(segment.argument, locale, arguments, resolver, buffer);
            }
            return;
        }
        buffer.append(this.toString());
    }

    @Override
    public String getType() {
        return "choice";
    }

    @Override
    public String getStyle() {
        return null;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("choice");
        sb.append(",");
        for (Choice choice : this.choices) {
            sb.append(choice);
        }
        return sb.toString();
    }

    private static class Condition
    implements Filter<Object> {
        private final CompareOperator comparator;
        private final Object comparatorArgument;

        public Condition(CompareOperator comparator, Object comparatorArgument) {
            this.comparator = comparator;
            this.comparatorArgument = comparatorArgument;
        }

        @Override
        public boolean accept(Object value) {
            if (this.comparator == null) {
                return true;
            }
            return this.comparator.eval(value, this.comparatorArgument);
        }

        public String toString() {
            if (this.comparator == null) {
                return "(else)";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("(?");
            buffer.append(this.comparator.getValue());
            buffer.append(this.comparatorArgument);
            buffer.append(")");
            return buffer.toString();
        }
    }

    public static class Segment {
        private final String literal;
        private final NlsArgument argument;

        public Segment(String literal, NlsArgument argument) {
            this.literal = literal == null ? "" : literal;
            this.argument = argument;
        }

        public String getLiteral() {
            return this.literal;
        }

        public NlsArgument getArgument() {
            return this.argument;
        }
    }

    public static final class Choice {
        private final Filter<Object> condition;
        private final List<Segment> segments;

        private Choice(Filter<Object> condition, List<Segment> segments) {
            this.condition = condition;
            this.segments = segments;
        }

        public Filter<Object> getCondition() {
            return this.condition;
        }

        public boolean isElse() {
            return this.condition == FILTER_ELSE;
        }

        public List<Segment> getSegments() {
            return this.segments;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.condition);
            for (Segment segment : this.segments) {
                buffer.append('\'');
                buffer.append(segment.literal.replace("'", "''"));
                buffer.append('\'');
                if (segment.argument == null) continue;
                buffer.append(segment.argument);
            }
            return buffer.toString();
        }
    }
}

